/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.sorted.spilling.impl;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.io.ByteReader;
import com.complexible.common.io.ObjectWriter;
import com.complexible.common.io.ObjectWriterFactory;
import com.complexible.memory.accessor.MemoryBlockChainByteReaderWriter;
import com.complexible.memory.file.FileReader;
import com.complexible.memory.file.FileWriter;
import com.complexible.memory.file.impl.DefaultFileReader;
import com.complexible.memory.file.impl.DefaultFileWriter;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.structure.CollectionIterator;
import com.complexible.memory.structure.ConventionalOutputCollector;
import com.complexible.memory.structure.ObjectSupplier;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.OperationType;
import com.complexible.memory.structure.TapeIterator;
import com.complexible.memory.structure.impl.array.sorted.BaseIndexOutputCollector;
import com.complexible.memory.structure.impl.array.sorted.index.BinaryIndex;
import com.complexible.memory.structure.impl.array.sorted.index.DiskIndex;
import com.complexible.memory.structure.impl.array.sorted.index.MemoryIndex;
import com.complexible.memory.structure.impl.array.sorted.spilling.impl.BaseAddressingSpillingSupportedSortableArray;
import com.complexible.memory.structure.impl.tape.MemoryBlockAddressArea;
import com.complexible.memory.structure.impl.tape.addressing.sort.ConventionalMemorySortableTape;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.structure.sort.iterator.GenericMultiInputIterator;
import com.complexible.memory.structure.sort.sorters.Sorter;
import com.complexible.memory.util.SpillingUtil;
import com.complexible.memory.util.Utilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.function.Supplier;

abstract class BaseConventionalSpillingSupportedSortableArray<I extends GenericMultiInputIterator, O extends ConventionalOutputCollector<TapeElementInput>, H extends Sorter<I, O>, SI extends CollectionIterator, COMPARATOR, MC extends ConventionalMemorySortableTape<COMPARATOR>>
extends BaseAddressingSpillingSupportedSortableArray<I, O, H, MemoryBlockAddressArea, MC, SI> {
    protected final BinaryIndex mDiskIndex;
    protected final BinaryIndex mMemoryIndex;
    protected final FileReader<FileInputStream> mDataFileReader;
    private final FileWriter<FileOutputStream> mDataFileWriter;
    private final FileReader<FileInputStream> mBlobDataFileReader;
    protected final ObjectSupplier<ByteReader> mReaderObjectSupplier;
    protected final Supplier<MemoryBlockChain> mDataMemoryBlockChainSupplier;
    protected final ConventionalOutputCollector<TapeElementInput> mIndexOutputCollector;
    protected final COMPARATOR mComparator;

    BaseConventionalSpillingSupportedSortableArray(MC theMemorySortableTape, DefaultFileReader theAddressingFileReader, DefaultFileWriter theAddressingFileWriter, DefaultFileReader theDataFileReader, DefaultFileWriter theDataFileWriter, int theSpillingBufferSize, SortOrder theDirection, COMPARATOR theComparator, OperationTracker theOperationTracker) {
        super(theMemorySortableTape, theAddressingFileReader, theAddressingFileWriter, theSpillingBufferSize, theDirection, theOperationTracker);
        this.mComparator = theComparator;
        this.mDataFileReader = theDataFileReader;
        this.mDataFileWriter = theDataFileWriter;
        this.mReaderObjectSupplier = new ObjectSupplier();
        this.mDataMemoryBlockChainSupplier = theMemorySortableTape.getDataMemoryBlockChainSupplier();
        this.mIndexOutputCollector = new IndexOutPutCollector((ConventionalOutputCollector)this.mSpillingOutputCollector, theAddressingFileWriter, theOperationTracker);
        this.mDiskIndex = this.createDiskIndex(this.mTapeFileReader);
        this.mMemoryIndex = this.createMemoryIndex(this.mTapeMemoryBlockChainAccessor);
        this.mBlobDataFileReader = new DefaultFileReader(theSpillingBufferSize);
    }

    @Override
    protected boolean isEmpty() {
        return ((MemoryBlockAddressArea)this.mTapeArea).get().isEmpty() || this.mDataMemoryBlockChainSupplier.get().getMemoryElementsCount() == 0L;
    }

    @Override
    public SI getSkippingTapeIterator() {
        return super.getSkippingTapeIterator();
    }

    @Override
    public SI createSkippingTapeIterator() {
        return super.createSkippingTapeIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void spillBlob(T theObject, ObjectWriterFactory<T> theFactory) {
        try {
            this.mOperationTracker.onStart(OperationType.SPILLING);
            File aBlobFile = SpillingUtil.ensureFile(this.mMemoryContext.getSpillingDirectory());
            try {
                this.writeOnDisk(theObject, theFactory, aBlobFile);
                this.mBlobDataFileReader.setInput(aBlobFile);
                this.doSpillBlob(this.mBlobDataFileReader);
            }
            catch (IOException theE) {
                try {
                    throw Utilities.rethrow(theE);
                }
                catch (Throwable throwable) {
                    AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mBlobDataFileReader, () -> SpillingUtil.deleteFile(aBlobFile)});
                    throw throwable;
                }
            }
            AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mBlobDataFileReader, () -> SpillingUtil.deleteFile(aBlobFile)});
        }
        finally {
            this.mOperationTracker.onDone(OperationType.SPILLING);
        }
    }

    public void spillBlob(ByteReader theDataReader) {
        try {
            this.mOperationTracker.onStart(OperationType.SPILLING);
            this.doSpillBlob(theDataReader);
        }
        finally {
            this.mOperationTracker.onDone(OperationType.SPILLING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSpillBlob(ByteReader theDataReader) {
        Object aHeapSorter = this.getHeapSorter();
        aHeapSorter.setChunkSize(this.mSortingChunkSize);
        aHeapSorter.resetTo(this.getBlobToSpilledDualIterator(), (ConventionalOutputCollector)((ConventionalOutputCollector)this.mSpillingOutputCollector));
        File aDestinationFile = SpillingUtil.ensureFile(this.mMemoryContext.getSpillingDirectory());
        try {
            this.onSpillingStarted(aDestinationFile);
            this.mReaderObjectSupplier.set(theDataReader);
            aHeapSorter.assembleAll();
        }
        finally {
            this.mReaderObjectSupplier.set(null);
            this.onSpillingDone(aDestinationFile);
        }
    }

    public abstract TapeIterator getTapeIterator();

    protected abstract int slotSizeBitPosition();

    @Override
    protected boolean isDataSpilled() {
        return this.mDataMemoryBlockChainSupplier.get().getTotalSpilledBytes() > 0L;
    }

    private <T> void writeOnDisk(T theObject, ObjectWriterFactory<T> theFactory, File theDestinationFile) {
        try {
            this.mDataFileWriter.setOutput(theDestinationFile);
            ObjectWriter aObjectWriter = theFactory.writer(this.mDataFileWriter);
            aObjectWriter.write(theObject);
        }
        catch (IOException theE) {
            try {
                throw Utilities.rethrow(theE);
            }
            catch (Throwable throwable) {
                AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mDataFileWriter});
                throw throwable;
            }
        }
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mDataFileWriter});
    }

    @Override
    protected MemoryIndex createMemoryIndex(MemoryBlockChainByteReaderWriter theTapeMemoryBlockChainAccessor) {
        return new MemoryIndex(this.mTapeMemoryBlockChainAccessor, this.mDataMemoryBlockChainSupplier);
    }

    @Override
    protected DiskIndex createDiskIndex(FileReader theTapeFileReader) {
        return new DiskIndex(theTapeFileReader, this.mTapeArea, this.mDataMemoryBlockChainSupplier);
    }

    @Override
    protected void onSpillingStarted(File theNewSpilledFile) {
        SpillingUtil.openDiskReader(this.mDataFileReader, this.mDataMemoryBlockChainSupplier.get());
        try {
            this.mDataFileWriter.setOutput(theNewSpilledFile);
        }
        catch (FileNotFoundException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    protected void onSpillingDone(File theNewSpilledFile) {
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mDataFileReader, this.mDataFileWriter, () -> SpillingUtil.deleteFile(this.mDataMemoryBlockChainSupplier.get().getSpilledFile()), () -> this.mDataMemoryBlockChainSupplier.get().setSpilledFile(theNewSpilledFile), () -> this.mDataMemoryBlockChainSupplier.get().resetMemoryAfterSpill(true), () -> ((MemoryBlockAddressArea)this.mTapeArea).get().resetMemoryAfterSpill(true)});
    }

    @Override
    protected void onDiskIndexBuilt() {
        super.onDiskIndexBuilt();
        this.mDataMemoryBlockChainSupplier.get().setActualBlocksCount(0);
        this.mDataMemoryBlockChainSupplier.get().releaseUnusedBlocks();
    }

    @Override
    protected long getTotalSpilledBytes() {
        return this.mDataMemoryBlockChainSupplier.get().getTotalSpilledBytes();
    }

    @Override
    protected long getTotalElementsCount() {
        return this.mDataMemoryBlockChainSupplier.get().getTotalElementsCount();
    }

    protected abstract I getBlobInputIterator();

    protected abstract I getBlobToSpilledDualIterator();

    protected abstract I createByteReaderIterator(ObjectSupplier<ByteReader> var1);

    @Override
    public void dispose() {
        AutoCloseable[] autoCloseableArray = new AutoCloseable[9];
        autoCloseableArray[0] = () -> super.dispose();
        autoCloseableArray[1] = () -> this.getBlobInputIterator().dispose();
        autoCloseableArray[2] = () -> this.getBlobToSpilledDualIterator().dispose();
        autoCloseableArray[3] = this.mDiskIndex;
        autoCloseableArray[4] = this.mMemoryIndex;
        autoCloseableArray[5] = this.mDataFileReader;
        autoCloseableArray[6] = () -> this.mDataFileWriter.dispose();
        autoCloseableArray[7] = () -> this.mReaderObjectSupplier.set(null);
        autoCloseableArray[8] = this.mIndexOutputCollector::reset;
        AutoCloser.close((AutoCloseable[])autoCloseableArray);
    }

    static final class IndexOutPutCollector
    extends BaseIndexOutputCollector {
        IndexOutPutCollector(ConventionalOutputCollector<TapeElementInput> theBaseCollector, FileWriter theIndexWriter, OperationTracker theOperationTracker) {
            super(theBaseCollector, theIndexWriter, theOperationTracker);
        }
    }

    final class SpillingOutputCollector
    implements ConventionalOutputCollector<TapeElementInput> {
        private final OperationTracker mOperationTracker;

        SpillingOutputCollector(OperationTracker theOperationTracker) {
            this.mOperationTracker = SpillingUtil.resolveTracker(theOperationTracker);
        }

        @Override
        public void collect(TapeElementInput theTapeElementInput) {
            long aWrittenBytes = 8L + theTapeElementInput.getElementLength();
            try {
                BaseConventionalSpillingSupportedSortableArray.this.mDataFileWriter.writeLong(theTapeElementInput.getElementLength());
            }
            catch (IOException theE) {
                throw Utilities.rethrow(theE);
            }
            BaseConventionalSpillingSupportedSortableArray.this.mDataFileWriter.writeByteReader(theTapeElementInput);
            BaseConventionalSpillingSupportedSortableArray.this.mDataMemoryBlockChainSupplier.get().incrementTotalSpilledBytes(aWrittenBytes);
            this.mOperationTracker.onSpilling(aWrittenBytes);
        }
    }
}

