/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.sorted.spilling.impl;

import com.complexible.common.base.AutoCloser;
import com.complexible.memory.accessor.MemoryBlockChainByteReaderWriter;
import com.complexible.memory.file.FileReader;
import com.complexible.memory.file.impl.DefaultFileReader;
import com.complexible.memory.file.impl.DefaultFileWriter;
import com.complexible.memory.memoryblock.DefaultMemoryBlockChain;
import com.complexible.memory.structure.CollectionIterator;
import com.complexible.memory.structure.DataArea;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.OperationType;
import com.complexible.memory.structure.OutputCollector;
import com.complexible.memory.structure.impl.array.sorted.index.BinaryIndex;
import com.complexible.memory.structure.impl.array.sorted.spilling.impl.BaseSpillingSupportedSortableArray;
import com.complexible.memory.structure.impl.tape.addressing.sort.MemoryAddressingSortableTape;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.structure.sort.iterator.MultiInputIterator;
import com.complexible.memory.structure.sort.sorters.Sorter;
import com.complexible.memory.util.SpillingUtil;

abstract class BaseAddressingSpillingSupportedSortableArray<I extends MultiInputIterator, O extends OutputCollector, H extends Sorter<I, O>, D extends DataArea, M extends MemoryAddressingSortableTape<D>, SI extends CollectionIterator>
extends BaseSpillingSupportedSortableArray<I, O, H, D, M, SI> {
    BaseAddressingSpillingSupportedSortableArray(M theMemorySortableTape, DefaultFileReader theFileReader, DefaultFileWriter theFileWriter, int theSpillingBufferSize, SortOrder theDirection, OperationTracker theOperationTracker) {
        super(theMemorySortableTape, theFileReader, theFileWriter, theSpillingBufferSize, theDirection, theOperationTracker);
    }

    protected abstract O getIndexOutputCollector();

    protected abstract BinaryIndex createDiskIndex(FileReader var1);

    protected abstract BinaryIndex createMemoryIndex(MemoryBlockChainByteReaderWriter var1);

    protected void onDiskIndexBuilt() {
        DefaultMemoryBlockChain aTapeMemoryBlockChain = this.mTapeArea.get();
        aTapeMemoryBlockChain.setActualBlocksCount(0);
        aTapeMemoryBlockChain.releaseUnusedBlocks();
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mTapeFileWriter});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void buildSortedIndex() {
        if (((MemoryAddressingSortableTape)this.mMemorySortableTape).isIndexBuilt()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (((MemoryAddressingSortableTape)this.mMemorySortableTape).isIndexBuilt()) {
                return;
            }
            if (this.getTotalElementsCount() == 0L) {
                return;
            }
            if (this.getTotalSpilledBytes() > 0L) {
                this.buildDiskSortedIndex();
                ((MemoryAddressingSortableTape)this.mMemorySortableTape).markDiskIndexBuilt();
            } else {
                ((MemoryAddressingSortableTape)this.mMemorySortableTape).buildMemorySortedIndex(this.mOperationTracker);
            }
        }
    }

    protected void buildDiskSortedIndex() {
        if (this.mTapeArea.get().getSpilledFile() == null) {
            try {
                this.mOperationTracker.onStart(OperationType.SPILLING);
                SpillingUtil.openDiskWriter(this.mMemoryContext.getSpillingDirectory(), this.mTapeFileWriter, this.mTapeArea.get());
                try {
                    this.sortMemoryBlocksDataBeforeSpilling();
                    O aIndexOutputCollector = this.getIndexOutputCollector();
                    aIndexOutputCollector.reset();
                    this.spillDataToFile(aIndexOutputCollector);
                }
                finally {
                    this.onDiskIndexBuilt();
                }
            }
            finally {
                this.mOperationTracker.onDone(OperationType.SPILLING);
            }
        }
    }
}

