/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.sorted.multiple;

import com.complexible.memory.factory.CollectionFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.TripleLongSkippingIterator;
import com.complexible.memory.structure.TripleLongTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.multiple.BaseMultipleLongSortableArray;
import com.complexible.memory.structure.impl.array.sorted.spilling.impl.multiple.TripleLongSpillingSupportedSortableArrayImpl;
import com.complexible.memory.structure.impl.array.sorted.spilling.multiple.TripleLongSpillingSupportedSortableArray;
import com.complexible.memory.structure.impl.tape.MemoryBlocksDataArea;
import com.complexible.memory.structure.impl.tape.OutOfMemoryException;
import com.complexible.memory.structure.impl.tape.addressing.sort.impl.TripleLongSortableMemoryTape;
import com.complexible.memory.structure.sort.SortOrder;
import com.complexible.memory.structure.sort.TripleLongSortOrder;
import com.complexible.memory.structure.sort.TripleLongSortableArray;
import java.io.IOException;

public final class TripleLongSortableArrayImpl
extends BaseMultipleLongSortableArray<TripleLongSpillingSupportedSortableArray, TripleLongSortOrder, TripleLongSortableMemoryTape, TripleLongTapeIterator, TripleLongSkippingIterator, TripleLongSortableArray>
implements TripleLongSortableArray {
    public TripleLongSortableArrayImpl(int theSpillingBufferSize, MemoryContext theMemoryContext, CollectionFactory<TripleLongSortableArray> theCollectionFactory, SortOrder theDirection, TripleLongSortOrder theSortOrder, OperationTracker theOperationTracker) {
        super(theSpillingBufferSize, theMemoryContext, theCollectionFactory, theDirection, theSortOrder, theOperationTracker);
    }

    @Override
    public void append(long theLongValue1, long theLongValue2, long theLongValue3) throws IOException {
        try {
            ((TripleLongSortableMemoryTape)this.mMemorySortableTape).checkIndex();
            this.appendLongs(theLongValue1, theLongValue2, theLongValue3);
            this.onSuccess();
        }
        catch (OutOfMemoryException theE) {
            this.spillTapeToTheDisk();
            try {
                this.appendLongs(theLongValue1, theLongValue2, theLongValue3);
                this.onSuccess();
            }
            catch (OutOfMemoryException theEE) {
                this.spillTripleLong(theLongValue1, theLongValue2, theLongValue3);
            }
        }
    }

    @Override
    protected TripleLongSortableMemoryTape createMemorySortableTape() {
        return new TripleLongSortableMemoryTape(this.mDataAreaAccessor, this.mMemoryContext, this.mMemoryBlockChainFactory, this.mDirection, (TripleLongSortOrder)((Object)this.mSortOrder));
    }

    @Override
    protected TripleLongSpillingSupportedSortableArray createSpillingSupportedSortableArray(TripleLongSortableMemoryTape theMemorySortableTape, OperationTracker theOperationTracker) {
        return new TripleLongSpillingSupportedSortableArrayImpl(theMemorySortableTape, this.mDiskDataBlocksReader, this.mDiskDataBlocksWriter, this.mSpillingBufferSize, this.mDirection, (TripleLongSortOrder)((Object)this.mSortOrder), theOperationTracker);
    }

    @Override
    public TripleLongTapeIterator getTapeIterator() {
        return ((TripleLongSpillingSupportedSortableArray)this.mSpillingSupportedSortableArray).getTapeIterator();
    }

    @Override
    public TripleLongSkippingIterator getSkippingTapeIterator() {
        return ((TripleLongSpillingSupportedSortableArray)this.mSpillingSupportedSortableArray).getSkippingTapeIterator();
    }

    @Override
    protected TripleLongSortableArray getCollection() {
        return this;
    }

    private void spillTripleLong(long theLongValue1, long theLongValue2, long theLongValue3) {
        ((TripleLongSpillingSupportedSortableArray)this.mSpillingSupportedSortableArray).spillLongs(theLongValue1, theLongValue2, theLongValue3);
        ((MemoryBlocksDataArea)((TripleLongSortableMemoryTape)this.mMemorySortableTape).getTapeArea()).get().incrementTotalElementsCount();
    }

    private void appendLongs(long theLongValue1, long theLongValue2, long theLongValue3) {
        this.appendLong(theLongValue1);
        this.appendLong(theLongValue2);
        this.appendLong(theLongValue3);
    }

    @Override
    public TripleLongTapeIterator createTapeIterator() {
        return ((TripleLongSpillingSupportedSortableArray)this.mSpillingSupportedSortableArray).createTapeIterator();
    }

    @Override
    public TripleLongSkippingIterator createSkippingTapeIterator() {
        return ((TripleLongSpillingSupportedSortableArray)this.mSpillingSupportedSortableArray).createSkippingTapeIterator();
    }
}

