/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.sorted.multiple;

import com.complexible.memory.factory.CollectionFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.QuadLongSkippingIterator;
import com.complexible.memory.structure.QuadLongTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.multiple.BaseMultipleLongSortableArray;
import com.complexible.memory.structure.impl.array.sorted.spilling.impl.multiple.QuadLongSpillingSupportedSortableArrayImpl;
import com.complexible.memory.structure.impl.array.sorted.spilling.multiple.QuadLongSpillingSupportedSortableArray;
import com.complexible.memory.structure.impl.tape.MemoryBlocksDataArea;
import com.complexible.memory.structure.impl.tape.OutOfMemoryException;
import com.complexible.memory.structure.impl.tape.addressing.sort.impl.QuadLongSortableMemoryTape;
import com.complexible.memory.structure.sort.QuadLongSortOrder;
import com.complexible.memory.structure.sort.QuadLongSortableArray;
import com.complexible.memory.structure.sort.SortOrder;
import java.io.IOException;

public final class QuadLongSortableArrayImpl
extends BaseMultipleLongSortableArray<QuadLongSpillingSupportedSortableArray, QuadLongSortOrder, QuadLongSortableMemoryTape, QuadLongTapeIterator, QuadLongSkippingIterator, QuadLongSortableArray>
implements QuadLongSortableArray {
    public QuadLongSortableArrayImpl(int theSpillingBufferSize, MemoryContext theMemoryContext, CollectionFactory<QuadLongSortableArray> theCollectionFactory, SortOrder theDirection, QuadLongSortOrder theSortOrder, OperationTracker theOperationTracker) {
        super(theSpillingBufferSize, theMemoryContext, theCollectionFactory, theDirection, theSortOrder, theOperationTracker);
    }

    @Override
    public void append(long theLongValue1, long theLongValue2, long theLongValue3, long theLongValue4) throws IOException {
        try {
            ((QuadLongSortableMemoryTape)this.mMemorySortableTape).checkIndex();
            this.appendLongs(theLongValue1, theLongValue2, theLongValue3, theLongValue4);
            this.onSuccess();
        }
        catch (OutOfMemoryException theE) {
            this.spillTapeToTheDisk();
            try {
                this.appendLongs(theLongValue1, theLongValue2, theLongValue3, theLongValue4);
                this.onSuccess();
            }
            catch (OutOfMemoryException theEE) {
                this.spillQuadLong(theLongValue1, theLongValue2, theLongValue3, theLongValue4);
            }
        }
    }

    @Override
    protected QuadLongSortableMemoryTape createMemorySortableTape() {
        return new QuadLongSortableMemoryTape(this.mDataAreaAccessor, this.mMemoryContext, this.mMemoryBlockChainFactory, this.mDirection, (QuadLongSortOrder)((Object)this.mSortOrder));
    }

    @Override
    protected QuadLongSpillingSupportedSortableArray createSpillingSupportedSortableArray(QuadLongSortableMemoryTape theMemorySortableTape, OperationTracker theOperationTracker) {
        return new QuadLongSpillingSupportedSortableArrayImpl(theMemorySortableTape, this.mDiskDataBlocksReader, this.mDiskDataBlocksWriter, this.mSpillingBufferSize, this.mDirection, (QuadLongSortOrder)((Object)this.mSortOrder), theOperationTracker);
    }

    @Override
    public QuadLongTapeIterator getTapeIterator() {
        return ((QuadLongSpillingSupportedSortableArray)this.mSpillingSupportedSortableArray).getTapeIterator();
    }

    @Override
    public QuadLongSkippingIterator getSkippingTapeIterator() {
        return ((QuadLongSpillingSupportedSortableArray)this.mSpillingSupportedSortableArray).getSkippingTapeIterator();
    }

    @Override
    protected QuadLongSortableArray getCollection() {
        return this;
    }

    private void spillQuadLong(long theLongValue1, long theLongValue2, long theLongValue3, long theLongValue4) {
        ((QuadLongSpillingSupportedSortableArray)this.mSpillingSupportedSortableArray).spillLongs(theLongValue1, theLongValue2, theLongValue3, theLongValue4);
        ((MemoryBlocksDataArea)((QuadLongSortableMemoryTape)this.mMemorySortableTape).getTapeArea()).get().incrementTotalElementsCount();
    }

    private void appendLongs(long theLongValue1, long theLongValue2, long theLongValue3, long theLongValue4) {
        this.appendLong(theLongValue1);
        this.appendLong(theLongValue2);
        this.appendLong(theLongValue3);
        this.appendLong(theLongValue4);
    }

    @Override
    public QuadLongTapeIterator createTapeIterator() {
        return ((QuadLongSpillingSupportedSortableArray)this.mSpillingSupportedSortableArray).createTapeIterator();
    }

    @Override
    public QuadLongSkippingIterator createSkippingTapeIterator() {
        return ((QuadLongSpillingSupportedSortableArray)this.mSpillingSupportedSortableArray).createSkippingTapeIterator();
    }
}

