/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.sorted.multiple;

import com.complexible.memory.factory.CollectionFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.DoubleLongSkippingIterator;
import com.complexible.memory.structure.DoubleLongTapeIterator;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.impl.array.sorted.multiple.BaseMultipleLongSortableArray;
import com.complexible.memory.structure.impl.array.sorted.spilling.impl.multiple.DoubleLongSpillingSupportedSortableArrayImpl;
import com.complexible.memory.structure.impl.array.sorted.spilling.multiple.DoubleLongSpillingSupportedSortableArray;
import com.complexible.memory.structure.impl.tape.MemoryBlocksDataArea;
import com.complexible.memory.structure.impl.tape.OutOfMemoryException;
import com.complexible.memory.structure.impl.tape.addressing.sort.impl.DoubleLongSortableMemoryTape;
import com.complexible.memory.structure.sort.DoubleLongSortOrder;
import com.complexible.memory.structure.sort.DoubleLongSortableArray;
import com.complexible.memory.structure.sort.SortOrder;
import java.io.IOException;

public final class DoubleLongSortableArrayImpl
extends BaseMultipleLongSortableArray<DoubleLongSpillingSupportedSortableArray, DoubleLongSortOrder, DoubleLongSortableMemoryTape, DoubleLongTapeIterator, DoubleLongSkippingIterator, DoubleLongSortableArray>
implements DoubleLongSortableArray {
    public DoubleLongSortableArrayImpl(int theSpillingBufferSize, MemoryContext theMemoryContext, CollectionFactory<DoubleLongSortableArray> theCollectionFactory, SortOrder theDirection, DoubleLongSortOrder theSortOrder, OperationTracker theOperationTracker) {
        super(theSpillingBufferSize, theMemoryContext, theCollectionFactory, theDirection, theSortOrder, theOperationTracker);
    }

    @Override
    public void append(long theLongValue1, long theLongValue2) throws IOException {
        try {
            ((DoubleLongSortableMemoryTape)this.mMemorySortableTape).checkIndex();
            this.appendLongs(theLongValue1, theLongValue2);
            this.onSuccess();
        }
        catch (OutOfMemoryException theE) {
            this.spillTapeToTheDisk();
            try {
                this.appendLongs(theLongValue1, theLongValue2);
                this.onSuccess();
            }
            catch (OutOfMemoryException theEE) {
                this.spillDoubleLong(theLongValue1, theLongValue2);
            }
        }
    }

    @Override
    protected DoubleLongSortableMemoryTape createMemorySortableTape() {
        return new DoubleLongSortableMemoryTape(this.mDataAreaAccessor, this.mMemoryContext, this.mMemoryBlockChainFactory, this.mDirection, (DoubleLongSortOrder)((Object)this.mSortOrder));
    }

    @Override
    protected DoubleLongSpillingSupportedSortableArray createSpillingSupportedSortableArray(DoubleLongSortableMemoryTape theMemorySortableTape, OperationTracker theOperationTracker) {
        return new DoubleLongSpillingSupportedSortableArrayImpl(theMemorySortableTape, this.mDiskDataBlocksReader, this.mDiskDataBlocksWriter, this.mSpillingBufferSize, this.mDirection, (DoubleLongSortOrder)((Object)this.mSortOrder), theOperationTracker);
    }

    @Override
    public DoubleLongTapeIterator getTapeIterator() {
        return ((DoubleLongSpillingSupportedSortableArray)this.mSpillingSupportedSortableArray).getTapeIterator();
    }

    @Override
    public DoubleLongSkippingIterator getSkippingTapeIterator() {
        return ((DoubleLongSpillingSupportedSortableArray)this.mSpillingSupportedSortableArray).getSkippingTapeIterator();
    }

    @Override
    protected DoubleLongSortableArray getCollection() {
        return this;
    }

    private void spillDoubleLong(long theLongValue1, long theLongValue2) {
        ((DoubleLongSpillingSupportedSortableArray)this.mSpillingSupportedSortableArray).spillLongs(theLongValue1, theLongValue2);
        ((MemoryBlocksDataArea)((DoubleLongSortableMemoryTape)this.mMemorySortableTape).getTapeArea()).get().incrementTotalElementsCount();
    }

    private void appendLongs(long theLongValue1, long theLongValue2) {
        this.appendLong(theLongValue1);
        this.appendLong(theLongValue2);
    }

    @Override
    public DoubleLongTapeIterator createTapeIterator() {
        return ((DoubleLongSpillingSupportedSortableArray)this.mSpillingSupportedSortableArray).createTapeIterator();
    }

    @Override
    public DoubleLongSkippingIterator createSkippingTapeIterator() {
        return ((DoubleLongSpillingSupportedSortableArray)this.mSpillingSupportedSortableArray).createSkippingTapeIterator();
    }
}

