/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.sorted.iterator.skipping.addressable.multiple;

import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.addressable.multiple.BaseLongMemoryAddressableTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.iterator.skipping.addressable.multiple.LongAddressableTapeIterator;
import com.complexible.memory.util.Utilities;
import java.io.IOException;
import java.util.function.Supplier;

public class LongMemoryAddressableTapeIterator
extends BaseLongMemoryAddressableTapeIterator
implements LongAddressableTapeIterator {
    private long mLongValue;

    public LongMemoryAddressableTapeIterator(MemoryContext theMemoryContext, Supplier<MemoryBlockChain> theMemoryBlockChainObjectSupplier) {
        super(theMemoryContext, theMemoryBlockChainObjectSupplier);
    }

    @Override
    protected void readNext() {
        try {
            this.mLongValue = this.mAddressAccessor.readLong();
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    protected int getSlotSize() {
        return 8;
    }

    @Override
    protected long calculateAddress(long theElementsCount) {
        return Utilities.multiplyLongPowerOfTwoAsLong(theElementsCount, 3);
    }

    @Override
    public long next() {
        this.iterateNext();
        return this.mLongValue;
    }

    @Override
    public long current() {
        return this.mLongValue;
    }
}

