/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.sorted.iterator.skipping.addressable.multiple;

import com.complexible.common.base.AutoCloser;
import com.complexible.memory.file.impl.DefaultFileReader;
import com.complexible.memory.structure.iterator.AddressableTapeIterator;
import com.complexible.memory.util.Utilities;
import java.io.IOException;

abstract class BaseLongDiskAddressableTapeIterator
implements AddressableTapeIterator {
    protected final DefaultFileReader mFileReader;

    public BaseLongDiskAddressableTapeIterator(DefaultFileReader theFileReader) {
        this.mFileReader = theFileReader;
    }

    @Override
    public void gotoAddress(long theAddress) {
        if (theAddress > 0L) {
            try {
                this.mFileReader.setPosition(theAddress);
            }
            catch (IOException theE) {
                throw Utilities.rethrow(theE);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.mFileReader.checkAvailable(8);
    }

    @Override
    public void reset() {
        try {
            this.mFileReader.setPosition(0L);
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public void dispose() {
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mFileReader});
    }

    @Override
    public void close() {
        this.mFileReader.close();
    }
}

