/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.sorted.iterator.skipping.addressable;

import com.complexible.common.base.AutoCloser;
import com.complexible.memory.file.FileReader;
import com.complexible.memory.structure.BaseConventionalTapeIterator;
import com.complexible.memory.structure.impl.array.sorted.index.BinaryIndex;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.input.TapeElementInputFactory;
import com.complexible.memory.structure.iterator.ConventionalAddressableTapeIterator;
import com.complexible.memory.structure.sort.iterator.ConventionalMultiInputIterator;
import com.complexible.memory.util.Utilities;
import java.io.IOException;

public final class DiskAddressableTapeIterator<T extends TapeElementInput, F extends TapeElementInputFactory<T>>
extends BaseConventionalTapeIterator<T>
implements ConventionalAddressableTapeIterator<T> {
    private long mCurrentAddress;
    private final BinaryIndex mBinaryIndex;
    private final FileReader mDefaultFileReader;
    private final ConventionalMultiInputIterator<T, F> mDiskInputIterator;

    public DiskAddressableTapeIterator(ConventionalMultiInputIterator<T, F> theDiskInputIterator, BinaryIndex theBinaryIndex, FileReader theDefaultFileReader) {
        this.mBinaryIndex = theBinaryIndex;
        this.mDefaultFileReader = theDefaultFileReader;
        this.mDiskInputIterator = theDiskInputIterator;
        this.reset0();
    }

    @Override
    public boolean hasNext0() {
        if (this.mCurrentAddress == -1L) {
            return false;
        }
        if (this.mDiskInputIterator.next(0)) {
            this.mTapeElementInput = this.mDiskInputIterator.getInput(0);
            return true;
        }
        this.reset0();
        return false;
    }

    @Override
    public T next0() {
        return (T)this.mTapeElementInput;
    }

    @Override
    public void reset0() {
        this.resetIterator();
        try {
            this.mBinaryIndex.getSource().setPosition(0L);
            this.mDefaultFileReader.setPosition(0L);
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public void gotoAddress(long theAddress) {
        this.mCurrentAddress = theAddress;
        if (theAddress >= 0L) {
            try {
                this.mDiskInputIterator.reset();
                this.mBinaryIndex.getSource().setPosition(theAddress);
                this.mDefaultFileReader.setPosition(this.mBinaryIndex.getSource().readLong());
            }
            catch (IOException theE) {
                throw Utilities.rethrow(theE);
            }
        }
    }

    @Override
    protected void close0() {
        this.resetIterator();
        this.mBinaryIndex.close();
        this.mDefaultFileReader.close();
    }

    @Override
    public void dispose0() {
        AutoCloseable[] autoCloseableArray = new AutoCloseable[2];
        autoCloseableArray[0] = this::close0;
        autoCloseableArray[1] = this.mDiskInputIterator::dispose;
        AutoCloser.close((AutoCloseable[])autoCloseableArray);
    }

    private void resetIterator() {
        this.mTapeElementInput = null;
        this.mDiskInputIterator.reset();
    }
}

