/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.sorted;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.io.ByteReader;
import com.complexible.common.io.ObjectWriterFactory;
import com.complexible.memory.factory.CollectionFactory;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.LongOptimizedSkippingIterator;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.impl.array.sorted.BaseConventionalSortableArray;
import com.complexible.memory.structure.impl.array.sorted.spilling.impl.SpillingSupportedLongOptimizedSortableArrayImpl;
import com.complexible.memory.structure.impl.tape.addressing.sort.LongOptimizedSortableTape;
import com.complexible.memory.structure.impl.tape.addressing.sort.impl.LongOptimizedSortableMemoryTape;
import com.complexible.memory.structure.sort.LongComparator;
import com.complexible.memory.structure.sort.LongOptimizedSortableArray;
import com.complexible.memory.structure.sort.SortOrder;
import java.io.IOException;

public final class LongOptimizedSortableArrayImpl
extends BaseConventionalSortableArray<SpillingSupportedLongOptimizedSortableArrayImpl, LongOptimizedSortableTape, LongComparator, LongOptimizedSortableArray>
implements LongOptimizedSortableArray {
    private long mCompareLongIndex;
    private long mCachedCompareLong;
    private static final int SLOT_SIZE_BYTES = 16;

    public LongOptimizedSortableArrayImpl(int theSpillingBufferSize, MemoryContext theMemoryContext, SortOrder theSortOrder, LongComparator theLongComparator, OperationTracker theOperationTracker) {
        super(theSpillingBufferSize, theMemoryContext, null, theSortOrder, theLongComparator, theOperationTracker);
    }

    public LongOptimizedSortableArrayImpl(int theSpillingBufferSize, MemoryContext theMemoryContext, CollectionFactory<LongOptimizedSortableArray> theCollectionFactory, SortOrder theSortOrder, LongComparator theLongComparator, OperationTracker theOperationTracker) {
        super(theSpillingBufferSize, theMemoryContext, theCollectionFactory, theSortOrder, theLongComparator, theOperationTracker);
    }

    @Override
    protected LongOptimizedSortableArray getCollection() {
        return this;
    }

    @Override
    public LongOptimizedSkippingIterator getSkippingTapeIterator() {
        boolean aBarrier = this.mBarrier;
        return (LongOptimizedSkippingIterator)((SpillingSupportedLongOptimizedSortableArrayImpl)this.mSpillingSupportedSortableArray).getSkippingTapeIterator();
    }

    @Override
    public LongOptimizedSkippingIterator createSkippingTapeIterator() {
        boolean aBarrier = this.mBarrier;
        return (LongOptimizedSkippingIterator)((SpillingSupportedLongOptimizedSortableArrayImpl)this.mSpillingSupportedSortableArray).createSkippingTapeIterator();
    }

    @Override
    public void append(ByteReader theDataReader) throws IOException {
        this.readComparingLong(theDataReader);
        super.append(theDataReader);
    }

    @Override
    protected <TT> void writeBytes(TT theObject, ObjectWriterFactory<TT> theFactory) throws IOException {
        long aPosition = this.mDataAreaAccessor.getPosition();
        super.writeBytes(theObject, theFactory);
        this.mCachedCompareLong = this.mDataAreaAccessor.readLong(aPosition + 8L + this.mCompareLongIndex);
    }

    @Override
    protected <TT> void spillBlob(TT theObject, ObjectWriterFactory<TT> theFactory) throws IOException {
        ((SpillingSupportedLongOptimizedSortableArrayImpl)this.mSpillingSupportedSortableArray).spillBlob(theObject, (ObjectWriterFactory)theFactory);
        this.mDiskDataBlocksReader.setInput(this.mDataMemoryBlockChain.getSpilledFile());
        try {
            this.mDiskDataBlocksReader.setPosition(this.mCompareLongIndex);
            this.mCachedCompareLong = this.mDiskDataBlocksReader.readLong();
        }
        catch (Throwable throwable) {
            AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mDiskDataBlocksReader});
            throw throwable;
        }
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this.mDiskDataBlocksReader});
        this.mBarrier = true;
    }

    @Override
    public void setComparableLongOffset(long theOffset) {
        this.mCompareLongIndex = theOffset;
        ((SpillingSupportedLongOptimizedSortableArrayImpl)this.mSpillingSupportedSortableArray).setComparableLongOffset(theOffset);
    }

    @Override
    protected void writeElementAddress(int theBlockIndex, int theOffset, MemoryBlockChain theMemoryBlockChain) {
        super.writeElementAddress(theBlockIndex, theOffset, theMemoryBlockChain);
        MemoryBlock aMemoryAccessor = theMemoryBlockChain.current();
        aMemoryAccessor.putLong(theMemoryBlockChain.currentBlockOffset() + 8, this.mCachedCompareLong);
    }

    @Override
    protected void stepToNextOffset(MemoryBlockChain theMemoryBlockChain) {
        super.stepToNextOffset(theMemoryBlockChain, 16);
    }

    @Override
    protected LongOptimizedSortableTape createMemorySortableTape(SortOrder theSortOrder, LongComparator theComparator) {
        return new LongOptimizedSortableMemoryTape(this.mAddressArea, this.mMemoryContext, this.mMemoryBlockChainFactory, this.mDataAreaAccessor, theSortOrder, theComparator);
    }

    @Override
    protected SpillingSupportedLongOptimizedSortableArrayImpl createSpillingSupportedSortableArray(LongOptimizedSortableTape theMemorySortableTape, SortOrder theSortOrder, LongComparator theComparator, OperationTracker theOperationTracker) {
        return new SpillingSupportedLongOptimizedSortableArrayImpl(theMemorySortableTape, this.mAddressingSpaceDefaultFileReader, this.mAddressingSpaceDefaultFileWriter, this.mDiskDataBlocksReader, this.mDiskDataBlocksWriter, this.mSpillingBufferSize, theSortOrder, theComparator, theOperationTracker);
    }

    private void readComparingLong(ByteReader theDataReader) throws IOException {
        theDataReader.setPosition(this.mCompareLongIndex);
        this.mCachedCompareLong = theDataReader.readLong();
        theDataReader.setPosition(0L);
    }
}

