/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.sorted;

import com.complexible.memory.file.FileWriter;
import com.complexible.memory.structure.ConventionalOutputCollector;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.util.SpillingUtil;
import com.complexible.memory.util.Utilities;
import java.io.IOException;

public abstract class BaseIndexOutputCollector
implements ConventionalOutputCollector<TapeElementInput> {
    protected long mCurrentOffset;
    protected final FileWriter mIndexWriter;
    private final OperationTracker mOperationTracker;
    private final ConventionalOutputCollector<TapeElementInput> mBaseCollector;

    public BaseIndexOutputCollector(ConventionalOutputCollector<TapeElementInput> theBaseCollector, FileWriter theIndexWriter, OperationTracker theOperationTracker) {
        this.mIndexWriter = theIndexWriter;
        this.mBaseCollector = theBaseCollector;
        this.mOperationTracker = SpillingUtil.resolveTracker(theOperationTracker);
    }

    @Override
    public void collect(TapeElementInput theTapeElementInput) {
        this.mBaseCollector.collect(theTapeElementInput);
        try {
            this.collectIndex(theTapeElementInput);
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
        long aWrittenBytes = theTapeElementInput.getElementLength() + 8L;
        this.mCurrentOffset += aWrittenBytes;
        this.mOperationTracker.onSpilling(aWrittenBytes);
    }

    @Override
    public void reset() {
        this.mCurrentOffset = 0L;
    }

    protected void collectIndex(TapeElementInput theTapeElementInput) throws IOException {
        this.mIndexWriter.writeLong(this.mCurrentOffset);
        this.mOperationTracker.onSpilling(8L);
    }
}

