/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.sorted;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.Disposables;
import com.complexible.common.io.ByteReader;
import com.complexible.common.io.ObjectWriterFactory;
import com.complexible.memory.factory.CollectionFactory;
import com.complexible.memory.memoryblock.DefaultMemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.Array;
import com.complexible.memory.structure.Collection;
import com.complexible.memory.structure.Comparator;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.TapeIterator;
import com.complexible.memory.structure.impl.array.sorted.spilling.ConventionalSpillingSupportedSortableArray;
import com.complexible.memory.structure.impl.tape.ConventionalSpillingSupportedAddressingTape;
import com.complexible.memory.structure.impl.tape.MemoryBlockAddressArea;
import com.complexible.memory.structure.impl.tape.addressing.sort.ConventionalMemorySortableTape;
import com.complexible.memory.structure.sort.SortOrder;
import java.io.IOException;

abstract class BaseConventionalSortableArray<C extends ConventionalSpillingSupportedSortableArray, M extends ConventionalMemorySortableTape, CMP extends Comparator, T extends Collection>
extends ConventionalSpillingSupportedAddressingTape<T>
implements Array {
    volatile boolean mBarrier = true;
    final MemoryBlockAddressArea mAddressArea;
    final M mConventionalMemorySortableTape;
    final C mSpillingSupportedSortableArray;

    BaseConventionalSortableArray(int theSpillingBufferSize, MemoryContext theMemoryContext, CollectionFactory<T> theCollectionFactory, SortOrder theSortOrder, CMP theLongComparator, OperationTracker theOperationTracker) {
        super(theSpillingBufferSize, theMemoryContext, theCollectionFactory, theOperationTracker);
        try {
            this.mAddressArea = new MemoryBlockAddressArea(this.mMemoryBlockChainFactory);
            this.mConventionalMemorySortableTape = this.createMemorySortableTape(theSortOrder, theLongComparator);
            this.mSpillingSupportedSortableArray = this.createSpillingSupportedSortableArray(this.mConventionalMemorySortableTape, theSortOrder, theLongComparator, theOperationTracker);
        }
        catch (Throwable t) {
            this.dispose();
            throw t;
        }
    }

    @Override
    public void createArray() {
        try {
            this.mAddressArea.createArea();
            super.createTape();
        }
        finally {
            this.mBarrier = true;
        }
    }

    @Override
    public void append(ByteReader theDataReader) throws IOException {
        this.mConventionalMemorySortableTape.checkIndex();
        super.append(theDataReader);
        this.mBarrier = true;
    }

    @Override
    public <TT> void append(TT theObject, ObjectWriterFactory<TT> theFactory) throws IOException {
        this.mConventionalMemorySortableTape.checkIndex();
        super.append(theObject, theFactory);
        this.mBarrier = true;
    }

    @Override
    protected void spillBlob(ByteReader theDataReader) throws IOException {
        this.mSpillingSupportedSortableArray.spillBlob(theDataReader);
        this.mBarrier = true;
    }

    @Override
    protected <TT> void spillBlob(TT theObject, ObjectWriterFactory<TT> theFactory) throws IOException {
        this.mSpillingSupportedSortableArray.spillBlob(theObject, theFactory);
        this.mBarrier = true;
    }

    @Override
    public TapeIterator getTapeIterator() {
        boolean aBarrier = this.mBarrier;
        return this.mSpillingSupportedSortableArray.getTapeIterator();
    }

    @Override
    public TapeIterator createTapeIterator() {
        boolean aBarrier = this.mBarrier;
        return this.mSpillingSupportedSortableArray.createTapeIterator();
    }

    @Override
    public void dispose() {
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{() -> super.dispose(), () -> {
            if (this.mAddressArea != null) {
                this.mAddressArea.dispose();
            }
        }, Disposables.asCloseable(this.mConventionalMemorySortableTape), Disposables.asCloseable(this.mSpillingSupportedSortableArray)});
    }

    @Override
    protected void writeDataAddressToAddressSpace(int theBlockIndex, int theOffset) throws IOException {
        DefaultMemoryBlockChain aMemoryBlockChain = this.mAddressArea.get();
        this.writeElementAddress(theBlockIndex, theOffset, aMemoryBlockChain);
        this.stepToNextOffset(aMemoryBlockChain);
        this.refreshActualBlocks(aMemoryBlockChain);
    }

    @Override
    protected boolean checkAvailableAddressSpace() {
        return this.checkAvailableAddressSpace(this.mAddressArea.get());
    }

    @Override
    protected boolean obtainNextBlock(MemoryBlockChain theMemoryBlockChain) {
        if (theMemoryBlockChain.obtainNext()) {
            if (theMemoryBlockChain.size() == 1) {
                MemoryBlock aMemoryBlock = theMemoryBlockChain.get(0);
                this.mConventionalMemorySortableTape.unsetMemoryIndexByte(aMemoryBlock);
                this.mConventionalMemorySortableTape.unsetMemorySortedSeparatelyByte(aMemoryBlock);
            }
            return true;
        }
        return false;
    }

    protected void writeElementAddress(int theBlockIndex, int theOffset, MemoryBlockChain theMemoryBlockChain) {
        MemoryBlock aMemoryAccessor = theMemoryBlockChain.current();
        int aCurrentBlockOffset = theMemoryBlockChain.currentBlockOffset();
        aMemoryAccessor.putInt(aCurrentBlockOffset, theBlockIndex);
        aMemoryAccessor.putInt(aCurrentBlockOffset + 4, theOffset);
    }

    protected void stepToNextOffset(MemoryBlockChain aMemoryBlockChain) {
        super.stepToNextOffset(aMemoryBlockChain, 8);
    }

    @Override
    protected final void spillTapeToTheDisk() {
        this.mSpillingSupportedSortableArray.spillToTheDisk();
    }

    protected abstract M createMemorySortableTape(SortOrder var1, CMP var2);

    protected abstract C createSpillingSupportedSortableArray(M var1, SortOrder var2, CMP var3, OperationTracker var4);
}

