/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.iterator;

import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.BaseConventionalTapeIterator;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.sort.iterator.impl.MemoryChainMultiInputIterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public final class MemoryTapeIterator
extends BaseConventionalTapeIterator<TapeElementInput> {
    private final AtomicInteger mIteratorCounter;
    private final MemoryChainMultiInputIterator mMemoryChainMultiInputIterator;

    public MemoryTapeIterator(MemoryContext theMemoryContext, Supplier<MemoryBlockChain> theDataMemoryBlockChainHolder, AtomicInteger theIteratorCounter) {
        this.mIteratorCounter = theIteratorCounter;
        this.mMemoryChainMultiInputIterator = new MemoryChainMultiInputIterator(theDataMemoryBlockChainHolder, theMemoryContext);
        theIteratorCounter.incrementAndGet();
    }

    @Override
    protected boolean hasNext0() {
        if (this.mMemoryChainMultiInputIterator.next(0)) {
            this.mTapeElementInput = this.mMemoryChainMultiInputIterator.takeInput(0);
            return true;
        }
        return false;
    }

    @Override
    protected TapeElementInput next0() {
        return this.mTapeElementInput;
    }

    @Override
    protected void reset0() {
        this.mTapeElementInput = null;
        this.mMemoryChainMultiInputIterator.reset();
    }

    @Override
    protected void close0() {
        this.reset0();
    }

    @Override
    protected void dispose0() {
        this.mMemoryChainMultiInputIterator.dispose();
        this.mIteratorCounter.decrementAndGet();
    }
}

