/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.array.iterator;

import com.complexible.memory.file.FileReader;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.BaseConventionalTapeIterator;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.sort.iterator.impl.GenericDiskMultiInputIterator;
import com.complexible.memory.util.Utilities;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public final class DiskTapeIterator
extends BaseConventionalTapeIterator<TapeElementInput> {
    private boolean mIsActive;
    private final AtomicInteger mIteratorCounter;
    private final FileReader mDiskDataBlocksReader;
    private final GenericDiskMultiInputIterator mDiskInputIterator;
    private final Supplier<MemoryBlockChain> mDataMemoryBlockChainHolder;

    public DiskTapeIterator(FileReader theDiskDataBlocksReader, MemoryBlockChainFactory theMemoryBlockChainFactory, Supplier<MemoryBlockChain> theDataMemoryBlockChainHolder, MemoryContext theMemoryContext, AtomicInteger mIteratorCounter) {
        this.mIteratorCounter = mIteratorCounter;
        this.mIsActive = false;
        this.mDiskDataBlocksReader = theDiskDataBlocksReader;
        this.mDataMemoryBlockChainHolder = theDataMemoryBlockChainHolder;
        this.mDiskInputIterator = new GenericDiskMultiInputIterator(theMemoryBlockChainFactory, theDiskDataBlocksReader, theMemoryContext);
        mIteratorCounter.incrementAndGet();
    }

    @Override
    protected boolean hasNext0() {
        if (!this.mIsActive) {
            this.activate();
        }
        if (this.mDiskInputIterator.next(0)) {
            this.mTapeElementInput = this.mDiskInputIterator.getInput(0);
            return true;
        }
        return false;
    }

    @Override
    protected TapeElementInput next0() {
        return this.mTapeElementInput;
    }

    @Override
    protected void reset0() {
        this.mIsActive = false;
        this.mDiskInputIterator.reset();
        this.mDiskDataBlocksReader.close();
    }

    @Override
    protected void close0() {
        this.mDiskDataBlocksReader.close();
        this.mIsActive = false;
    }

    @Override
    protected void dispose0() {
        this.mDiskDataBlocksReader.close();
        this.mIsActive = false;
        this.mDiskInputIterator.dispose();
        this.mIteratorCounter.decrementAndGet();
    }

    private void activate() {
        this.openFileReader();
        this.mIsActive = true;
    }

    private void openFileReader() {
        try {
            this.mDiskDataBlocksReader.setInput(this.mDataMemoryBlockChainHolder.get().getSpilledFile());
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }
}

