/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.aggregator.iterator.secondary;

import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.ConventionalAggregator;
import com.complexible.memory.structure.ObjectSupplier;
import com.complexible.memory.structure.impl.aggregator.AggregationPolicy;
import com.complexible.memory.structure.impl.aggregator.assembler.AggregatorAssembler;
import com.complexible.memory.structure.impl.aggregator.collector.AggregatorOutputCollector;
import com.complexible.memory.structure.impl.aggregator.iterator.secondary.BaseSKResultTapeIterator;
import com.complexible.memory.structure.impl.aggregator.iterator.secondary.SecondaryKeyDelimiter;
import com.complexible.memory.structure.impl.hashtable.input.DefaultHashTableTapeElementInputFactory;
import com.complexible.memory.structure.input.HashTableTapeElementInput;
import com.complexible.memory.structure.input.HashTableTapeElementInputFactory;
import com.complexible.memory.structure.iterator.ConventionalHashTableTapeIterator;
import com.complexible.memory.structure.iterator.ConventionalSegmentedTapeIterator;

public class SingleSKResultTapeIterator
extends BaseSKResultTapeIterator
implements AggregatorOutputCollector,
ConventionalHashTableTapeIterator {
    private boolean mSegmentDone;
    private boolean mAssemblingDone;
    private boolean mFirstSegmentDone;
    private final AggregatorAssembler mAssembler;
    protected HashTableTapeElementInput mPendingElement;

    public SingleSKResultTapeIterator(MemoryContext theMemoryContext, AggregatorAssembler theAssembler, ConventionalAggregator theAggregator, ConventionalSegmentedTapeIterator theAggregatorMainIterator, ObjectSupplier<AggregationPolicy> thePolicyObjectSupplier) {
        this(theMemoryContext, theAssembler, theAggregator, theAggregatorMainIterator, thePolicyObjectSupplier, new DefaultHashTableTapeElementInputFactory(theMemoryContext));
    }

    protected SingleSKResultTapeIterator(MemoryContext theMemoryContext, AggregatorAssembler theAssembler, ConventionalAggregator theAggregator, ConventionalSegmentedTapeIterator theAggregatorMainIterator, ObjectSupplier<AggregationPolicy> thePolicyObjectSupplier, HashTableTapeElementInputFactory theTapeElementInputFactory) {
        super(theMemoryContext, theAggregator, theAggregatorMainIterator, thePolicyObjectSupplier, theTapeElementInputFactory);
        this.mAssembler = theAssembler;
    }

    @Override
    public void collectSegment(int theHashCode, int thePartitionHashCode, long theRecordsCount) {
        if (!this.mFirstSegmentDone) {
            this.mFirstSegmentDone = true;
            return;
        }
        if (!this.mAggregationStrategy.isInputAggregated() && this.mAggregationStrategy.getComparator() != null) {
            this.initIterator();
        }
        this.mSegmentDone = true;
    }

    @Override
    public void collect(HashTableTapeElementInput theTapeElementInput) {
        if (this.mSegmentDone) {
            this.mPendingElement = theTapeElementInput;
            return;
        }
        if (this.mAggregationStrategy.getComparator() == null) {
            this.mTapeElementInput = theTapeElementInput;
            return;
        }
        if (!this.mAggregationStrategy.isInputAggregated()) {
            this.putToAggregator(theTapeElementInput);
        } else {
            this.mNextElement = theTapeElementInput;
        }
    }

    @Override
    public void reset0() {
        super.reset0();
        this.mIterationDone = false;
        this.mAssemblingDone = false;
        this.mAssembler.resetTo(this.mAggregatorMainIterator, this);
    }

    @Override
    public void dispose0() {
        super.dispose0();
        this.mAssembler.dispose();
    }

    @Override
    protected boolean nextPKInput() {
        if (this.mAssemblingDone) {
            return false;
        }
        if (this.mPendingElement != null) {
            this.mTapeElementInput = this.mPendingElement;
            this.mPendingElement = null;
            return true;
        }
        if (this.mAssembler.assemble()) {
            this.mSegmentDone = true;
            this.mAssemblingDone = true;
            this.mTapeElementInput = SecondaryKeyDelimiter.INSTANCE;
            return true;
        }
        if (this.mSegmentDone) {
            this.mSegmentDone = false;
            this.mTapeElementInput = SecondaryKeyDelimiter.INSTANCE;
            return true;
        }
        return true;
    }

    @Override
    protected boolean nextAggregatedInput() {
        do {
            if (!this.mSegmentDone) {
                this.processAggregatedInput();
                return true;
            }
            this.mSegmentDone = false;
        } while (!this.mAssemblingDone);
        this.resetFields();
        return false;
    }

    @Override
    protected void aggregateSegment() {
        if (this.mPendingElement != null) {
            this.putToAggregator(this.mPendingElement);
            this.mPendingElement = null;
        }
        this.mSegmentDone = false;
        super.aggregateSegment();
        this.mSegmentDone = true;
    }

    @Override
    protected void aggregateNext() {
        this.nextSegmentElement();
    }

    @Override
    protected boolean checkAggregated() {
        if (this.mAssemblingDone) {
            this.mIterationDone = true;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isSegmentAggregated() {
        return this.mSegmentDone;
    }

    @Override
    protected void resetFields() {
        this.mSegmentDone = false;
        this.mPendingElement = null;
        this.mFirstSegmentDone = false;
        super.resetFields();
    }

    @Override
    protected boolean nextSegmentElement() {
        if (this.mSegmentDone) {
            return false;
        }
        if (this.checkPending()) {
            return true;
        }
        if (this.mAssembler.assemble()) {
            if (!this.mAggregationStrategy.isInputAggregated()) {
                this.initIterator();
            }
            this.mSegmentDone = true;
            this.mAssemblingDone = true;
        }
        return !this.mSegmentDone;
    }

    private boolean checkPending() {
        if (this.mAggregationStrategy.isInputAggregated() && this.mPendingElement != null) {
            this.mNextElement = this.mPendingElement;
            this.mPendingElement = null;
            return true;
        }
        return false;
    }
}

