/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.aggregator.iterator.memory;

import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.structure.impl.aggregator.iterator.memory.PartitionsIterator;
import com.complexible.memory.structure.impl.hashtable.PartitionsArea;
import com.complexible.memory.structure.impl.hashtable.context.HashTableContext;
import com.complexible.memory.structure.impl.tape.MemoryBlockAddressArea;
import com.complexible.memory.structure.openaddressing.OpenAddressingTable;

public final class PartitionsIteratorImpl
implements PartitionsIterator {
    private int mPartitionId;
    private final PartitionsArea mPartitionsArea;
    private MemoryBlock mPartitionMemoryBlock;
    private final HashTableContext mHashTableContext;
    private final MemoryBlockAddressArea mOverFlowPartitionsArea;
    private final OpenAddressingTable<MemoryBlock> mOpenAddressingTable;

    public PartitionsIteratorImpl(PartitionsArea thePartitionsArea, MemoryBlockAddressArea theOverFlowPartitionsArea, OpenAddressingTable<MemoryBlock> theOpenAddressingTable, HashTableContext theHashTableContext) {
        this.mPartitionsArea = thePartitionsArea;
        this.mHashTableContext = theHashTableContext;
        this.mOpenAddressingTable = theOpenAddressingTable;
        this.mOverFlowPartitionsArea = theOverFlowPartitionsArea;
    }

    @Override
    public boolean hasNext() {
        if (this.mPartitionMemoryBlock != null && this.checkPartitionMemoryBlock(false)) {
            return true;
        }
        do {
            ++this.mPartitionId;
            if (this.mPartitionId == this.mPartitionsArea.getPartitionsCount()) {
                return false;
            }
            this.mPartitionMemoryBlock = this.mPartitionsArea.getPartition(this.mPartitionId);
        } while (!this.checkPartitionMemoryBlock(true));
        return true;
    }

    @Override
    public MemoryBlock getPartition() {
        return this.mHashTableContext.getPartition();
    }

    @Override
    public MemoryBlock partitionMemoryBlock() {
        return this.mPartitionMemoryBlock;
    }

    @Override
    public void reset() {
        this.resetTo(null);
    }

    @Override
    public void resetTo(MemoryBlock thePartitionMemoryBlock) {
        this.mPartitionId = -1;
        this.mPartitionMemoryBlock = thePartitionMemoryBlock;
        this.mHashTableContext.setPartitionOverFlowBlock(thePartitionMemoryBlock);
    }

    private boolean checkPartitionMemoryBlock(boolean theIsHeaderBlock) {
        if (theIsHeaderBlock) {
            int aFirstOverFlowBlockId = this.mPartitionMemoryBlock.getHeader().getInt(32L);
            this.checkOverFlowBlock(aFirstOverFlowBlockId);
            return this.checkSlots();
        }
        int aNextOverFlowBlockId = this.mPartitionMemoryBlock.getHeader().getInt(32L);
        if (this.checkOverFlowBlock(aNextOverFlowBlockId)) {
            return this.checkSlots();
        }
        return this.checkPartitionMemoryBlock() && this.checkSlots();
    }

    private boolean checkOverFlowBlock(int theFirstOverFlowBlockId) {
        if (theFirstOverFlowBlockId >= 0) {
            this.mPartitionMemoryBlock = this.mOverFlowPartitionsArea.getMemoryBlock(theFirstOverFlowBlockId);
            this.mHashTableContext.setPartitionOverFlowBlock(this.mPartitionMemoryBlock);
            return true;
        }
        this.mHashTableContext.setPartitionOverFlowBlock(this.mPartitionsArea.getPartition(this.mPartitionId));
        return false;
    }

    private boolean checkSlots() {
        this.mOpenAddressingTable.setMemoryAccessor(this.mPartitionMemoryBlock);
        return this.mOpenAddressingTable.getSlotsCount() != 0;
    }

    private boolean checkPartitionMemoryBlock() {
        MemoryBlock aHeadMemoryBlock = this.mPartitionsArea.getPartition(this.mPartitionId);
        if (this.mPartitionMemoryBlock == aHeadMemoryBlock) {
            return false;
        }
        this.mPartitionMemoryBlock = aHeadMemoryBlock;
        return true;
    }

    public void dispose() {
        this.reset();
    }
}

