/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.aggregator.iterator;

import com.complexible.memory.structure.BaseConventionalTapeIterator;
import com.complexible.memory.structure.input.HashTableTapeElementInput;
import com.complexible.memory.structure.iterator.ConventionalSegmentedTapeIterator;

public final class DefaultAggregatorTapeIterator
extends BaseConventionalTapeIterator<HashTableTapeElementInput>
implements ConventionalSegmentedTapeIterator {
    private boolean mDiskDone;
    private boolean mMemoryDone;
    private ConventionalSegmentedTapeIterator mPendingIterator;
    private final ConventionalSegmentedTapeIterator mDiskIterator;
    private final ConventionalSegmentedTapeIterator mMemoryIterator;

    public DefaultAggregatorTapeIterator(ConventionalSegmentedTapeIterator theDiskIterator, ConventionalSegmentedTapeIterator theMemoryIterator) {
        this.mDiskIterator = theDiskIterator;
        this.mMemoryIterator = theMemoryIterator;
    }

    @Override
    public boolean hasNext0() {
        if (this.mPendingIterator != null && this.mPendingIterator.hasNext()) {
            this.mTapeElementInput = this.mPendingIterator.next();
            return true;
        }
        return false;
    }

    @Override
    public HashTableTapeElementInput next0() {
        return (HashTableTapeElementInput)this.mTapeElementInput;
    }

    @Override
    public int partitionHashCode() {
        return this.mPendingIterator.partitionHashCode();
    }

    @Override
    public long recordsCount() {
        return this.mPendingIterator.recordsCount();
    }

    @Override
    public int currentHashCode() {
        return this.mPendingIterator.currentHashCode();
    }

    @Override
    public boolean nextSegment() {
        this.setInitialState();
        return this.checkDiskSegment() || this.checkMemorySegment();
    }

    @Override
    public void setUniquenessMode(boolean theKeyUniqueness) {
        this.mMemoryIterator.setUniquenessMode(theKeyUniqueness);
    }

    @Override
    public void reset0() {
        this.mDiskDone = this.resetIterator(this.mDiskIterator);
        this.mMemoryDone = this.resetIterator(this.mMemoryIterator);
        this.mPendingIterator = null;
    }

    @Override
    protected void close0() {
        this.mDiskIterator.close();
        this.mMemoryIterator.close();
    }

    @Override
    public void dispose0() {
        this.mDiskIterator.dispose();
        this.mMemoryIterator.dispose();
    }

    private boolean resetIterator(ConventionalSegmentedTapeIterator theIterator) {
        if (theIterator != null) {
            theIterator.reset();
            return false;
        }
        return true;
    }

    private boolean checkDiskSegment() {
        if (!this.mDiskDone) {
            if (this.processIteratorSegment(this.mDiskIterator)) {
                return true;
            }
            this.mDiskDone = true;
        }
        return false;
    }

    private boolean checkMemorySegment() {
        if (!this.mMemoryDone) {
            if (this.processIteratorSegment(this.mMemoryIterator)) {
                return true;
            }
            this.mMemoryDone = true;
        }
        return false;
    }

    private boolean processIteratorSegment(ConventionalSegmentedTapeIterator theIterator) {
        if (theIterator.nextSegment()) {
            this.mPendingIterator = theIterator;
            return true;
        }
        return false;
    }
}

