/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.aggregator.iterator;

import com.complexible.memory.file.FileReader;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.structure.BaseConventionalTapeIterator;
import com.complexible.memory.structure.impl.aggregator.assembler.AggregatorAssembler;
import com.complexible.memory.structure.impl.aggregator.collector.AggregatorOutputCollector;
import com.complexible.memory.structure.input.HashTableTapeElementInput;
import com.complexible.memory.structure.iterator.ConventionalHashTableTapeIterator;
import com.complexible.memory.structure.iterator.ConventionalSegmentedTapeIterator;
import com.complexible.memory.util.Utilities;
import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;

public final class AggregatorResultTapeIterator
extends BaseConventionalTapeIterator<HashTableTapeElementInput>
implements ConventionalHashTableTapeIterator,
AggregatorOutputCollector {
    private boolean mIsActive;
    private final AggregatorAssembler mAssembler;
    private final FileReader mDiskDataBlocksReader;
    private final Supplier<MemoryBlockChain> mObjectSupplier;
    private final ConventionalSegmentedTapeIterator mAggregatorMainIterator;

    public AggregatorResultTapeIterator(AggregatorAssembler theAssembler, FileReader theDiskDataBlocksReader, ConventionalSegmentedTapeIterator theAggregatorMainIterator, Supplier<MemoryBlockChain> theMemoryBlockChainHolder) {
        this.mAssembler = theAssembler;
        this.mObjectSupplier = theMemoryBlockChainHolder;
        this.mDiskDataBlocksReader = theDiskDataBlocksReader;
        this.mAggregatorMainIterator = theAggregatorMainIterator;
    }

    @Override
    public boolean hasNext0() {
        if (!this.mIsActive) {
            this.openReader();
            this.mIsActive = true;
        }
        if (this.mAssembler.assemble()) {
            this.mIsActive = false;
            this.mDiskDataBlocksReader.close();
            return false;
        }
        return true;
    }

    @Override
    public HashTableTapeElementInput next0() {
        return (HashTableTapeElementInput)this.mTapeElementInput;
    }

    @Override
    public void collect(HashTableTapeElementInput theTapeElementInput) {
        this.mTapeElementInput = theTapeElementInput;
    }

    @Override
    public void reset0() {
        this.mIsActive = false;
        this.mDiskDataBlocksReader.close();
        this.mAssembler.resetTo(this.mAggregatorMainIterator, this);
    }

    @Override
    protected void close0() {
        this.mIsActive = false;
        this.mDiskDataBlocksReader.close();
        this.mAggregatorMainIterator.close();
    }

    @Override
    public void dispose0() {
        this.mIsActive = false;
        this.mDiskDataBlocksReader.close();
        this.mAggregatorMainIterator.dispose();
    }

    private void openReader() {
        File aSpilledFile = this.mObjectSupplier.get().getSpilledFile();
        if (aSpilledFile != null) {
            try {
                this.mDiskDataBlocksReader.setInput(aSpilledFile);
            }
            catch (IOException theE) {
                throw Utilities.rethrow(theE);
            }
        }
    }
}

