/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.aggregator.iterator;

import com.complexible.memory.structure.impl.aggregator.AggregatorResultStorage;
import com.complexible.memory.structure.impl.aggregator.iterator.BaseAggregatorSegmentedTapeIterator;
import com.complexible.memory.structure.input.HashTableTapeElementInput;
import com.complexible.memory.structure.input.TapeElementInput;
import com.complexible.memory.structure.iterator.ConventionalAddressableTapeIterator;

public final class AggregatorPKStorageSegmentedTapeIterator
extends BaseAggregatorSegmentedTapeIterator {
    private long mRecordsCounter;
    private long mSegmentAddress;
    private ConventionalAddressableTapeIterator<HashTableTapeElementInput> mIterator;
    private final AggregatorResultStorage mSKAggregatorSegmentedInputStorage;

    public AggregatorPKStorageSegmentedTapeIterator(AggregatorResultStorage theSegmentedInputStorage) {
        this.mSKAggregatorSegmentedInputStorage = theSegmentedInputStorage;
    }

    @Override
    public boolean nextSegment0() {
        if (!this.mIterator.hasNext()) {
            return false;
        }
        TapeElementInput aSegment = this.mIterator.next();
        this.mSegmentAddress = aSegment.address();
        this.mHashCode = aSegment.readInt();
        this.mPartitionHashCode = aSegment.readInt();
        this.mRecordsCounter = this.mRecordsCount = aSegment.readLong();
        return true;
    }

    @Override
    public boolean hasNext0() {
        if (this.mRecordsCounter == 0L) {
            return false;
        }
        --this.mRecordsCounter;
        return true;
    }

    @Override
    public HashTableTapeElementInput next0() {
        return (HashTableTapeElementInput)this.mIterator.next();
    }

    @Override
    public void resetSegment() {
        this.setInitialState();
        this.mIterator.gotoAddress(this.mSegmentAddress + 16L + 8L);
        this.mRecordsCounter = this.mRecordsCount;
    }

    @Override
    public void reset0() {
        this.mIterator = this.mSKAggregatorSegmentedInputStorage.getTapeIterator();
    }

    @Override
    protected void close0() {
        if (this.mIterator != null) {
            this.mIterator.close();
        }
    }
}

