/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.aggregator.iterator;

import com.complexible.common.io.ByteReader;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.impl.hashtable.PartitionsArea;
import com.complexible.memory.structure.impl.hashtable.comparator.HashComparator;
import com.complexible.memory.structure.impl.hashtable.context.ConventionalHashTableContext;
import com.complexible.memory.structure.impl.hashtable.iterator.MemoryTapeIterator;
import com.complexible.memory.structure.impl.tape.MemoryBlockAddressArea;
import com.complexible.memory.structure.impl.tape.addressing.hashtape.impl.HashTableUtil;
import com.complexible.memory.structure.input.HashTableTapeElementInput;
import com.complexible.memory.structure.iterator.ConventionalSegmentedTapeIterator;
import com.complexible.memory.structure.openaddressing.ConventionalOpenAddressingTable;
import java.util.function.Supplier;

public final class AggregatorMemoryAssemblingTapeIterator
extends MemoryTapeIterator
implements ConventionalSegmentedTapeIterator {
    private long mTotalCount;

    public AggregatorMemoryAssemblingTapeIterator(PartitionsArea thePartitionsArea, MemoryBlockAddressArea theOverFlowPartitionsArea, HashComparator theMemoryHashComparator, ConventionalOpenAddressingTable<MemoryBlock> theOpenAddressingLongKey, Supplier<MemoryBlockChain> theDataMemoryBlockChainHolder, ConventionalHashTableContext theHashTableContext, MemoryContext theMemoryContext) {
        super(thePartitionsArea, theOverFlowPartitionsArea, theMemoryHashComparator, theOpenAddressingLongKey, theDataMemoryBlockChainHolder, theHashTableContext, theMemoryContext, false);
    }

    @Override
    public boolean hasNext0() {
        if (this.mTotalCount == 0L) {
            return false;
        }
        this.finish();
        if (this.checkNextAddress(false)) {
            return true;
        }
        while (this.checkNextMemoryBlock()) {
            this.mIsElementHeader = true;
            this.mOpenAddressingTable.setMemoryAccessor(this.mPartitionMemoryBlock);
            this.mNextAddress = this.mOpenAddressingTable.payload();
            this.mOpenAddressingTable.setPayLoad(-1L);
            if (!this.checkNextAddress(true)) continue;
            return true;
        }
        this.reset0();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean nextSegment() {
        if (this.mHashTableContext.getPartition() == null) {
            return false;
        }
        this.setInitialState();
        this.checkActivate();
        this.mPartitionMemoryBlock = this.mHashTableContext.getPartitionOverFlowBlock();
        try {
            if (this.mPartitionMemoryBlock == this.mHashTableContext.getPartition()) {
                boolean bl = false;
                return bl;
            }
            long aTotalCount = 0L;
            while (this.checkNextMemoryBlock()) {
                aTotalCount += this.processPartition();
            }
            this.mTotalCount = aTotalCount;
            boolean bl = aTotalCount > 0L;
            return bl;
        }
        finally {
            this.mPartitionMemoryBlock = this.mHashTableContext.getPartitionOverFlowBlock();
        }
    }

    @Override
    public void setUniquenessMode(boolean theKeyUniqueness) {
        this.mKeyUniqueness = theKeyUniqueness;
        this.mTapeElementInputFactory.setUniquenessMode(theKeyUniqueness);
    }

    @Override
    public int partitionHashCode() {
        return this.mHashTableContext.getCachedPartitionHashCode();
    }

    @Override
    public int currentHashCode() {
        return this.mHashTableContext.getCachedHashCode();
    }

    @Override
    public long recordsCount() {
        return this.mTotalCount;
    }

    @Override
    public void dispose0() {
        super.dispose0();
        this.mOpenAddressingTable.setMemoryAccessor(null);
    }

    private boolean checkNextAddress(boolean isElementHeader) {
        if (this.mNextAddress != -1L) {
            this.mIsElementHeader = isElementHeader;
            this.processNextAddress();
            return true;
        }
        return false;
    }

    private void checkActivate() {
        if (!this.isActive) {
            this.isActive = true;
        }
    }

    private long processPartition() {
        long aSegmentAddress;
        this.mOpenAddressingTable.initOpenAddressing(this.mPartitionMemoryBlock);
        ByteReader keyReader = this.mHashTableContext.getKeyReader();
        this.resetReader(keyReader);
        long aTotalCount = 0L;
        boolean isActual = false;
        long aSegmentCellAddress = this.mOpenAddressingTable.lookUpSlot(keyReader, this.mHashTableContext.getCachedHashCode());
        if (aSegmentCellAddress != -1L && (aSegmentAddress = this.mPartitionMemoryBlock.getLong(aSegmentCellAddress)) >= 0L) {
            isActual = true;
            if (!this.mKeyUniqueness) {
                this.mTapeElementInputFactory.setUniquenessMode(false);
                this.mTapeElementInputFactory.setElementHeader(true);
                long aCount = ((HashTableTapeElementInput)this.mTapeElementInputFactory.createMemoryInput(this.mMemoryContext, (MemoryBlockChain)this.mDataMemoryBlockChainHolder.get(), aSegmentAddress)).getSegmentElementsCount();
                aTotalCount += aCount;
            } else {
                ++aTotalCount;
            }
            this.mIsElementHeader = true;
            this.mNextAddress = aSegmentAddress;
            HashTableUtil.markPartitionSlot(this.mPartitionMemoryBlock, aSegmentCellAddress, aSegmentAddress);
            this.mOpenAddressingTable.setPayLoad(aSegmentAddress);
            this.mOpenAddressingTable.decrementSlotCount();
        }
        if (!isActual) {
            this.mIsElementHeader = false;
            this.mNextAddress = -1L;
            this.mOpenAddressingTable.setPayLoad(-1L);
        }
        return aTotalCount;
    }

    @Override
    public void reset0() {
        super.reset0();
        this.mTotalCount = 0L;
    }

    @Override
    protected void close0() {
        this.reset0();
    }
}

