/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.aggregator.collector;

import com.complexible.memory.file.FileWriter;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.impl.aggregator.collector.AggregatorOutputCollector;
import com.complexible.memory.structure.input.HashTableTapeElementInput;
import com.complexible.memory.util.SpillingUtil;
import com.complexible.memory.util.Utilities;
import java.io.IOException;
import org.apache.commons.lang3.mutable.MutableLong;

class BaseDiskOutputCollector
implements AggregatorOutputCollector {
    final FileWriter mDiskDataBlocksWriter;
    final MutableLong mSpilledBytesCount;
    protected final OperationTracker mOperationTracker;

    BaseDiskOutputCollector(FileWriter theDiskDataBlocksWriter, MutableLong theSpilledBytesCount, OperationTracker theOperationTracker) {
        this.mSpilledBytesCount = theSpilledBytesCount;
        this.mDiskDataBlocksWriter = theDiskDataBlocksWriter;
        this.mOperationTracker = SpillingUtil.resolveTracker(theOperationTracker);
    }

    @Override
    public void collect(HashTableTapeElementInput theTapeElementInput) {
        long aWrittenBytes = 8L + theTapeElementInput.getElementLength();
        try {
            theTapeElementInput.setPosition(0L);
            this.mDiskDataBlocksWriter.writeLong(theTapeElementInput.getElementLength());
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
        this.mDiskDataBlocksWriter.writeByteReader(theTapeElementInput);
        this.mSpilledBytesCount.add(aWrittenBytes);
        this.mOperationTracker.onSpilling(aWrittenBytes);
    }
}

