/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.aggregator.accessor;

import com.complexible.memory.accessor.ByteAccessor;
import com.complexible.memory.accessor.MemoryBlockChainByteReaderWriter;
import com.complexible.memory.accessor.impl.ByteOrderUtil;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.util.Utilities;
import java.io.IOException;
import java.util.function.Supplier;

public final class MemoryBlockChainByteReaderWriterImpl
implements MemoryBlockChainByteReaderWriter {
    private long mPosition;
    private final int mBlockSize;
    private final int mBlockSizeMask;
    private final boolean mUseBigEndian;
    private final int mBlockSizeBitPosition;
    private final byte[] buffer = new byte[8];
    private final Supplier<MemoryBlockChain> mMemoryBlockChainObjectSupplier;

    public MemoryBlockChainByteReaderWriterImpl(Supplier<MemoryBlockChain> theMemoryBlockChainObjectSupplier, MemoryContext theMemoryContext) {
        this.mBlockSize = theMemoryContext.getBlockSize();
        this.mUseBigEndian = theMemoryContext.isUseBigEndian();
        this.mBlockSizeMask = theMemoryContext.getBlockSizeMask();
        this.mBlockSizeBitPosition = theMemoryContext.getBlockSizeBitPosition();
        this.mMemoryBlockChainObjectSupplier = theMemoryBlockChainObjectSupplier;
    }

    public long length() throws IOException {
        return Utilities.multiplyIntPowerOfTwoAsLong(this.mMemoryBlockChainObjectSupplier.get().size(), this.mBlockSizeBitPosition);
    }

    public long getPosition() throws IOException {
        return this.mPosition;
    }

    public void setPosition(long thePosition) {
        this.mPosition = thePosition;
    }

    public int read(byte[] theData) throws IOException {
        return this.read(theData, 0, theData.length);
    }

    public int read(byte[] theData, int theOffset, int theLength) throws IOException {
        int bytesToCopy;
        int aSrcOffset = this.getOffset(this.mPosition);
        int aBlockIndex = this.getIndex(this.mPosition);
        int aDstOffset = theOffset;
        for (int aRemaining = theLength; aRemaining > 0; aRemaining -= bytesToCopy) {
            bytesToCopy = Math.min(aRemaining, this.mBlockSize - aSrcOffset);
            this.memoryAccessor(aBlockIndex).copyToByteArray(aSrcOffset, theData, aDstOffset, bytesToCopy);
            aSrcOffset = 0;
            ++aBlockIndex;
            aDstOffset += bytesToCopy;
        }
        this.mPosition += (long)theLength;
        return theLength;
    }

    public int readNative(long address, int theLength) throws IOException {
        int bytesToCopy;
        int aSrcOffset = this.getOffset(this.mPosition);
        int aBlockIndex = this.getIndex(this.mPosition);
        int aDstOffset = 0;
        for (int aRemaining = theLength; aRemaining > 0; aRemaining -= bytesToCopy) {
            bytesToCopy = Math.min(aRemaining, this.mBlockSize - aSrcOffset);
            this.memoryAccessor(aBlockIndex).copyToNativeMemory(aSrcOffset, address + (long)aDstOffset, bytesToCopy);
            aSrcOffset = 0;
            ++aBlockIndex;
            aDstOffset += bytesToCopy;
        }
        this.mPosition += (long)theLength;
        return theLength;
    }

    public byte readByte() throws IOException {
        int aSrcOffset = this.getOffset(this.mPosition);
        int aBlockIndex = this.getIndex(this.mPosition);
        if (this.mBlockSize - aSrcOffset < 1) {
            aSrcOffset = 0;
            ++aBlockIndex;
        }
        ++this.mPosition;
        return this.memoryAccessor(aBlockIndex).getByte(aSrcOffset);
    }

    public int readInt() throws IOException {
        int aSrcOffset = this.getOffset(this.mPosition);
        int aBlockIndex = this.getIndex(this.mPosition);
        if (this.mBlockSize - aSrcOffset < 4) {
            this.read(this.buffer, 0, 4);
            this.mPosition += 4L;
            return ByteOrderUtil.readInt(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.buffer, 0L, this.mUseBigEndian);
        }
        this.mPosition += 4L;
        return this.memoryAccessor(aBlockIndex).getInt(aSrcOffset);
    }

    public long readVLong() throws IOException {
        return this.readLong();
    }

    public int readVInt() throws IOException {
        return this.readInt();
    }

    public long readLong() throws IOException {
        int aSrcOffset = this.getOffset(this.mPosition);
        int aBlockIndex = this.getIndex(this.mPosition);
        if (this.mBlockSize - aSrcOffset < 8) {
            this.read(this.buffer, 0, 8);
            this.mPosition += 8L;
            return ByteOrderUtil.readLong(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.buffer, 0L, this.mUseBigEndian);
        }
        this.mPosition += 8L;
        return this.memoryAccessor(aBlockIndex).getLong(aSrcOffset);
    }

    public double readDouble() throws IOException {
        int aSrcOffset = this.getOffset(this.mPosition);
        int aBlockIndex = this.getIndex(this.mPosition);
        if (this.mBlockSize - aSrcOffset < 8) {
            this.read(this.buffer, 0, 8);
            this.mPosition += 8L;
            return ByteOrderUtil.readDouble(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.buffer, 0L, this.mUseBigEndian);
        }
        this.mPosition += 8L;
        return this.memoryAccessor(aBlockIndex).getDouble(aSrcOffset);
    }

    public float readFloat() throws IOException {
        int aSrcOffset = this.getOffset(this.mPosition);
        int aBlockIndex = this.getIndex(this.mPosition);
        if (this.mBlockSize - aSrcOffset < 4) {
            this.read(this.buffer, 0, 4);
            this.mPosition += 4L;
            return ByteOrderUtil.readFloat(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.buffer, 0L, this.mUseBigEndian);
        }
        this.mPosition += 4L;
        return this.memoryAccessor(aBlockIndex).getFloat(aSrcOffset);
    }

    public short readShort() throws IOException {
        int aSrcOffset = this.getOffset(this.mPosition);
        int aBlockIndex = this.getIndex(this.mPosition);
        if (this.mBlockSize - aSrcOffset < 2) {
            this.read(this.buffer, 0, 2);
            this.mPosition += 2L;
            return ByteOrderUtil.readShort(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.buffer, 0L, this.mUseBigEndian);
        }
        this.mPosition += 2L;
        return this.memoryAccessor(aBlockIndex).getShort(aSrcOffset);
    }

    public void write(byte[] theData) throws IOException {
        this.write(theData, 0, theData.length);
    }

    public void write(byte[] theData, int theOffset, int theLength) throws IOException {
        int bytesToCopy;
        int aDstOffset = this.getOffset(this.mPosition);
        int aBlockIndex = this.getIndex(this.mPosition);
        int aSrcOffset = theOffset;
        for (int aRemaining = theLength; aRemaining > 0; aRemaining -= bytesToCopy) {
            bytesToCopy = Math.min(aRemaining, this.mBlockSize - aDstOffset);
            this.memoryAccessor(aBlockIndex).copyFromByteArray(theData, aSrcOffset, aDstOffset, bytesToCopy);
            aDstOffset = 0;
            ++aBlockIndex;
            aSrcOffset += bytesToCopy;
        }
        this.mPosition += (long)theLength;
    }

    public void writeByte(byte theValue) throws IOException {
        int aDstOffset = this.getOffset(this.mPosition);
        int aBlockIndex = this.getIndex(this.mPosition);
        if (this.mBlockSize - aDstOffset < 1) {
            aDstOffset = 0;
            ++aBlockIndex;
        }
        this.memoryAccessor(aBlockIndex).putByte(aDstOffset, theValue);
        ++this.mPosition;
    }

    public void writeInt(int theValue) throws IOException {
        int aDstOffset = this.getOffset(this.mPosition);
        int aBlockIndex = this.getIndex(this.mPosition);
        if (this.mBlockSize - aDstOffset < 4) {
            ByteOrderUtil.writeInt(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.buffer, 0L, theValue, this.mUseBigEndian);
            this.write(this.buffer, 0, 4);
            this.mPosition += 4L;
            return;
        }
        this.memoryAccessor(aBlockIndex).putInt(aDstOffset, theValue);
        this.mPosition += 4L;
    }

    public void writeLong(long theValue) throws IOException {
        int aDstOffset = this.getOffset(this.mPosition);
        int aBlockIndex = this.getIndex(this.mPosition);
        if (this.mBlockSize - aDstOffset < 8) {
            ByteOrderUtil.writeLong(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.buffer, 0L, theValue, this.mUseBigEndian);
            this.write(this.buffer, 0, 8);
            this.mPosition += 8L;
            return;
        }
        this.memoryAccessor(aBlockIndex).putLong(aDstOffset, theValue);
        this.mPosition += 8L;
    }

    public void writeShort(short theValue) throws IOException {
        int aDstOffset = this.getOffset(this.mPosition);
        int aBlockIndex = this.getIndex(this.mPosition);
        if (this.mBlockSize - aDstOffset < 2) {
            ByteOrderUtil.writeShort(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.buffer, 0L, theValue, this.mUseBigEndian);
            this.write(this.buffer, 0, 2);
            this.mPosition += 2L;
            return;
        }
        this.memoryAccessor(aBlockIndex).putShort(aDstOffset, theValue);
        this.mPosition += 2L;
    }

    public void writeChar(char theValue) throws IOException {
        int aDstOffset = this.getOffset(this.mPosition);
        int aBlockIndex = this.getIndex(this.mPosition);
        if (this.mBlockSize - aDstOffset < 2) {
            ByteOrderUtil.writeChar(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.buffer, 0L, theValue, this.mUseBigEndian);
            this.write(this.buffer, 0, 2);
            this.mPosition += 2L;
            return;
        }
        this.memoryAccessor(aBlockIndex).putChar(aDstOffset, theValue);
        this.mPosition += 2L;
    }

    public void writeDouble(double theValue) throws IOException {
        int aDstOffset = this.getOffset(this.mPosition);
        int aBlockIndex = this.getIndex(this.mPosition);
        if (this.mBlockSize - aDstOffset < 8) {
            ByteOrderUtil.writeDouble(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.buffer, 0L, theValue, this.mUseBigEndian);
            this.write(this.buffer, 0, 8);
            this.mPosition += 8L;
            return;
        }
        this.memoryAccessor(aBlockIndex).putDouble(aDstOffset, theValue);
        this.mPosition += 8L;
    }

    public void writeFloat(float theValue) throws IOException {
        int aDstOffset = this.getOffset(this.mPosition);
        int aBlockIndex = this.getIndex(this.mPosition);
        if (this.mBlockSize - aDstOffset < 4) {
            ByteOrderUtil.writeFloat(ByteAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.buffer, 0L, theValue, this.mUseBigEndian);
            this.write(this.buffer, 0, 4);
            this.mPosition += 4L;
            return;
        }
        this.memoryAccessor(aBlockIndex).putFloat(aDstOffset, theValue);
        this.mPosition += 4L;
    }

    public void writeString(String theValue) throws IOException {
        throw new UnsupportedOperationException("");
    }

    public void writeBuffer(long[] theData, int theOffset, int theLength) {
        int bytesToCopy;
        int aDstOffset = this.getOffset(this.mPosition);
        int aBlockIndex = this.getIndex(this.mPosition);
        int aSrcOffset = theOffset;
        for (int aRemaining = theLength; aRemaining > 0; aRemaining -= bytesToCopy) {
            bytesToCopy = Math.min(aRemaining, this.mBlockSize - aDstOffset);
            this.memoryAccessor(aBlockIndex).copyFromLongArray(theData, aSrcOffset, aDstOffset, bytesToCopy);
            aDstOffset = 0;
            ++aBlockIndex;
            aSrcOffset += bytesToCopy;
        }
        this.mPosition += (long)theLength;
    }

    public String readString() throws IOException {
        throw new UnsupportedOperationException("");
    }

    public void writeVInt(int theValue) throws IOException {
        this.writeInt(theValue);
    }

    public void writeVLong(long theValue) throws IOException {
        this.writeLong(theValue);
    }

    public boolean isOverflowed() {
        return false;
    }

    @Override
    public MemoryBlockChain get() {
        return this.mMemoryBlockChainObjectSupplier.get();
    }

    @Override
    public void copyMemory(long theSourcePosition, long theTargetPosition, long theBytesCount) {
        this.copyMemory(theSourcePosition, theTargetPosition, theBytesCount, this.mMemoryBlockChainObjectSupplier.get());
    }

    @Override
    public void copyMemory(long theSourcePosition, long theTargetPosition, long theBytesCount, MemoryBlockChain theSourceMemoryBlockChain) {
        Utilities.copyMemory(theSourcePosition, theTargetPosition, theBytesCount, theSourceMemoryBlockChain, this.mMemoryBlockChainObjectSupplier.get(), this.mBlockSizeMask, this.mBlockSizeBitPosition, this.mBlockSize);
    }

    private int getOffset(long theSourcePosition) {
        return Utilities.maskLongPowerOfTwoAsInt(theSourcePosition, this.mBlockSizeMask);
    }

    private int getIndex(long theSourcePosition) {
        return Utilities.divideLongPowerOfTwoAsInt(theSourcePosition, this.mBlockSizeBitPosition);
    }

    private MemoryBlock memoryAccessor(int theBlockIndex) {
        return this.mMemoryBlockChainObjectSupplier.get().get(theBlockIndex);
    }
}

