/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure.impl.aggregator;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.Disposable;
import com.complexible.common.base.Disposables;
import com.complexible.common.io.ByteReader;
import com.complexible.memory.factory.CollectionFactory;
import com.complexible.memory.file.FileWriter;
import com.complexible.memory.file.impl.DefaultFileReader;
import com.complexible.memory.file.impl.DefaultFileWriter;
import com.complexible.memory.memoryblock.MemoryBlockChainFactory;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.Aggregator;
import com.complexible.memory.structure.Collection;
import com.complexible.memory.structure.Comparator;
import com.complexible.memory.structure.ConventionalAggregator;
import com.complexible.memory.structure.ObjectSupplier;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.structure.OperationType;
import com.complexible.memory.structure.TapeIterator;
import com.complexible.memory.structure.impl.aggregator.AggregationPolicy;
import com.complexible.memory.structure.impl.aggregator.AggregationStrategy;
import com.complexible.memory.structure.impl.aggregator.AggregatorResultStorage;
import com.complexible.memory.structure.impl.aggregator.BaseConventionalAggregator;
import com.complexible.memory.structure.impl.aggregator.SecondaryKeyAggregator;
import com.complexible.memory.structure.impl.aggregator.assembler.AggregatorAssembler;
import com.complexible.memory.structure.impl.aggregator.assembler.SingleIteratorAggregatorAssembler;
import com.complexible.memory.structure.impl.aggregator.collector.AggregatorOutputCollector;
import com.complexible.memory.structure.impl.aggregator.collector.SegmentedDiskOutputCollector;
import com.complexible.memory.structure.impl.aggregator.collector.SegmentedStorageOutputCollector;
import com.complexible.memory.structure.impl.aggregator.collector.SpillingDumpDiskOutputCollector;
import com.complexible.memory.structure.impl.aggregator.collector.StorageOutputCollector;
import com.complexible.memory.structure.impl.aggregator.functor.Functor;
import com.complexible.memory.structure.impl.aggregator.iterator.AggregatorDiskTapeIterator;
import com.complexible.memory.structure.impl.aggregator.iterator.AggregatorPKStorageSegmentedTapeIterator;
import com.complexible.memory.structure.impl.aggregator.iterator.secondary.MultiSKResultTapeIterator;
import com.complexible.memory.structure.impl.aggregator.iterator.secondary.SingleSKDiskResultTapeIterator;
import com.complexible.memory.structure.impl.aggregator.iterator.secondary.SingleSKResultTapeIterator;
import com.complexible.memory.structure.impl.hashtable.iterator.HashTableDiskMultiInputIterator;
import com.complexible.memory.structure.impl.hashtable.iterator.sort.HashTableMultiInputIterator;
import com.complexible.memory.structure.impl.tape.addressing.hashtape.impl.HashTableUtil;
import com.complexible.memory.structure.input.HashTableTapeElementInput;
import com.complexible.memory.structure.iterator.ConventionalHashTableTapeIterator;
import com.complexible.memory.structure.iterator.ConventionalSegmentedTapeIterator;
import com.complexible.memory.util.Utilities;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.mutable.MutableLong;

public final class DefaultAggregator
extends BaseConventionalAggregator {
    private AggregationPolicy mAggregationPolicy;
    private final SecondaryKeyAggregator mSkAggregator;
    private final ConventionalHashTableTapeIterator mSkDiskResultAggregatorTapeIterator;
    private final ConventionalHashTableTapeIterator mSkMemoryResultAggregatorTapeIterator;
    private final ConventionalHashTableTapeIterator mMultiStrategySKResultAggregatorTapeIterator;
    private final AggregatorOutputCollector mSpillingDumpDiskOutputCollector;
    private final AggregatorOutputCollector mSpillingDumpStorageOutputCollector;
    private final AggregatorOutputCollector mSpillingSecondaryDiskOutputCollector;
    private final AggregatorOutputCollector mSpillingSecondaryStorageOutputCollector;
    private final AggregatorOutputCollector mSpillingSecondaryDumpDiskOutputCollector;
    private final AggregatorResultStorage mResultArray;
    private final AggregatorResultStorage mSKSegmentedInputStorage;
    private final DefaultFileReader mSkDiskSpillingReader;
    private final AggregatorAssembler mSKAssembler;
    private final DefaultFileWriter mSKDiskDataBlocksWriter;
    private final ConventionalSegmentedTapeIterator mPKDiskAggregatorMainIterator;
    private final ConventionalSegmentedTapeIterator mPKMemoryAggregatorMainIterator;
    private final ObjectSupplier<AggregationPolicy> mAggregationPolicyObjectSupplier = new ObjectSupplier();
    private final MutableLong mDumpedBytesCount = new MutableLong(0L);
    private State mState = State.AGGREGATION;

    public DefaultAggregator(int theSpillingBufferSize, MemoryContext theMemoryContext, Comparator mDefaultComparator, OperationTracker theOperationTracker) {
        this(theSpillingBufferSize, theMemoryContext, mDefaultComparator, null, Utilities.DUMMY_INDEX, Utilities.DUMMY_INDEX, theOperationTracker);
    }

    public DefaultAggregator(int theSpillingBufferSize, MemoryContext theMemoryContext, Comparator mDefaultComparator, int theEstimatedKeysCount, int theSKEstimatedKeysCount, OperationTracker theOperationTracker) {
        this(theSpillingBufferSize, theMemoryContext, mDefaultComparator, null, theEstimatedKeysCount, theSKEstimatedKeysCount, theOperationTracker);
    }

    DefaultAggregator(int theSpillingBufferSize, MemoryContext theMemoryContext, Comparator mDefaultComparator, CollectionFactory<Aggregator> theCollectionFactory, int theEstimatedKeysCount, int theSKEstimatedKeysCount, OperationTracker theOperationTracker) {
        super(theSpillingBufferSize, theMemoryContext, HashTableUtil.calculatePartitionCount(theMemoryContext, theEstimatedKeysCount, 16), mDefaultComparator, theCollectionFactory, theOperationTracker);
        try {
            this.mSKAssembler = this.createSingleIteratorAssembler(theMemoryContext);
            this.mSkAggregator = this.createSKAggregator(theSpillingBufferSize, theMemoryContext, HashTableUtil.calculatePartitionCount(theMemoryContext, theSKEstimatedKeysCount, 16), theOperationTracker);
            this.mSpillingDumpDiskOutputCollector = this.createSpillingDumpDiskOutputCollector(this.mDumpedBytesCount, theOperationTracker);
            this.mSKDiskDataBlocksWriter = new DefaultFileWriter(theSpillingBufferSize, theMemoryContext.getMaxSpillingFileLength(), theMemoryContext.getSpillingSyncChunkSize());
            this.mSpillingSecondaryDumpDiskOutputCollector = this.createSpillingDumpDiskOutputCollector(this.mSKDiskDataBlocksWriter, this.mDumpedBytesCount, theOperationTracker);
            this.mSkDiskSpillingReader = new DefaultFileReader(theSpillingBufferSize);
            this.mPKDiskAggregatorMainIterator = this.createSKDiskAggregatorIterator();
            this.mSkDiskResultAggregatorTapeIterator = this.createSKDiskResultIterator();
            this.mPKMemoryAggregatorMainIterator = this.createMemoryAggregatorIterator(theMemoryContext);
            this.mSkMemoryResultAggregatorTapeIterator = this.createSKMemoryResultIterator();
            this.mResultArray = new AggregatorResultStorage(theSpillingBufferSize, theMemoryContext, theOperationTracker);
            this.mSKSegmentedInputStorage = new AggregatorResultStorage(theSpillingBufferSize, theMemoryContext, theOperationTracker);
            AggregatorPKStorageSegmentedTapeIterator aSegmentedIterator = new AggregatorPKStorageSegmentedTapeIterator(this.mSKSegmentedInputStorage);
            this.mMultiStrategySKResultAggregatorTapeIterator = new MultiSKResultTapeIterator(this.mMemoryContext, (ConventionalAggregator)this.mSkAggregator, (ConventionalSegmentedTapeIterator)aSegmentedIterator, this.mAggregationPolicyObjectSupplier, this.mMemoryBlockChainFactory);
            this.mSpillingDumpStorageOutputCollector = new StorageOutputCollector(this.mResultArray);
            this.mSpillingSecondaryStorageOutputCollector = new SegmentedStorageOutputCollector(this.mSKSegmentedInputStorage, theMemoryContext);
            this.mSpillingSecondaryDiskOutputCollector = new SegmentedDiskOutputCollector(this.mDiskDataBlocksWriter, this.mDumpedBytesCount, theOperationTracker);
            this.setComparator(mDefaultComparator);
        }
        catch (Throwable t) {
            this.dispose();
            throw t;
        }
    }

    @Override
    public void setFunctor(Functor theFunctor, long theValuePosition) {
        boolean aUniqueness = theFunctor != null && theFunctor.isAssociative();
        this.validateKeyUniquenessAndFunctorCompatibility(aUniqueness, theFunctor);
        super.setFunctor(theFunctor, theValuePosition);
        super.aggregateUniqueKeys(aUniqueness);
    }

    @Override
    public void aggregateUniqueKeys(boolean theKeyUniqueness) {
        if (this.mFunctor != null && this.mFunctor.isAssociative()) {
            this.validateKeyUniquenessAndFunctorCompatibility(true, this.mFunctor);
            super.aggregateUniqueKeys(true);
        } else {
            this.validateKeyUniquenessAndFunctorCompatibility(theKeyUniqueness, this.mFunctor);
            super.aggregateUniqueKeys(theKeyUniqueness);
        }
    }

    @Override
    public TapeIterator getTapeIterator(boolean mDump) {
        if (this.mState == State.DUMPED) {
            return this.mResultArray.getTapeIterator();
        }
        if (mDump) {
            this.dumpAggregationResults();
            this.disposeMemory();
            this.mResultArray.releaseUnUsedBlocks();
            this.mState = State.DUMPED;
            return this.mResultArray.getTapeIterator();
        }
        this.validateAggregatorState();
        return super.getTapeIterator();
    }

    private void dumpAggregationResults() {
        if (!this.hasSecondaryAggregationPolicy()) {
            this.dumpPrimaryAggregatorResults(this.mResultArray, this.mSpillingDumpDiskOutputCollector, this.mSpillingDumpStorageOutputCollector, this.mDumpedBytesCount);
        } else {
            this.dumpSecondaryAggregatorResults(this.mResultArray);
        }
    }

    @Override
    public void setSecondaryAggregationPolicy(AggregationPolicy theAggregationPolicy) {
        this.validateSecondaryAggregationPolicy(theAggregationPolicy);
        this.mAggregationPolicy = theAggregationPolicy;
        this.mSkAggregator.setAggregationPolicy(theAggregationPolicy);
        this.mAggregationPolicyObjectSupplier.set(theAggregationPolicy);
    }

    @Override
    protected ConventionalHashTableTapeIterator resolveIterator() {
        if (!this.hasSecondaryAggregationPolicy()) {
            return super.resolveIterator();
        }
        this.mSkAggregator.dispose();
        this.mSkAggregator.createAggregator();
        return this.mAggregationPolicy.aggregationStrategiesCount() == 1 ? this.singleStrategySecondaryIterator() : this.multiStrategySecondaryIterator();
    }

    @Override
    public void reset() {
        this.mState = State.AGGREGATION;
        this.mSkAggregator.dispose();
        this.mResultArray.dispose();
        this.mSKSegmentedInputStorage.dispose();
        super.reset();
    }

    @Override
    public void dispose() {
        if (this.mAggregationPolicyObjectSupplier != null) {
            this.mAggregationPolicyObjectSupplier.set(null);
        }
        this.mState = State.AGGREGATION;
        AutoCloser.close((AutoCloseable[])new AutoCloseable[]{() -> super.dispose(), Collection.asCloseable(this.mResultArray), Collection.asCloseable(this.mSkAggregator), Collection.asCloseable(this.mSKSegmentedInputStorage), Disposables.asCloseable((Disposable)this.mSKAssembler), this.mSkDiskSpillingReader, this.mSKDiskDataBlocksWriter, Disposables.asCloseable((Disposable)this.mPKDiskAggregatorMainIterator), Disposables.asCloseable((Disposable)this.mSkDiskResultAggregatorTapeIterator), Disposables.asCloseable((Disposable)this.mPKMemoryAggregatorMainIterator), Disposables.asCloseable((Disposable)this.mSkMemoryResultAggregatorTapeIterator), Disposables.asCloseable((Disposable)this.mMultiStrategySKResultAggregatorTapeIterator)});
    }

    private ConventionalHashTableTapeIterator singleStrategySecondaryIterator() {
        if (this.onlyMemory()) {
            return this.mSkMemoryResultAggregatorTapeIterator;
        }
        this.spillTapeToTheDisk();
        this.mSkAggregator.acceptPKMemory(this.mDataMemoryBlockChain, this.mPartitionsArea);
        this.mSkAggregator.reset();
        return this.mSkDiskResultAggregatorTapeIterator;
    }

    private ConventionalHashTableTapeIterator multiStrategySecondaryIterator() {
        this.dumpPrimaryAggregatorResults(this.mSKSegmentedInputStorage, this.mSpillingSecondaryDiskOutputCollector, this.mSpillingSecondaryStorageOutputCollector, this.mDumpedBytesCount);
        this.mSKSegmentedInputStorage.releaseUnUsedBlocks();
        this.mSkAggregator.acceptPKMemory(this.mDataMemoryBlockChain, this.mPartitionsArea);
        this.mSkAggregator.reset();
        return this.mMultiStrategySKResultAggregatorTapeIterator;
    }

    private void dumpPrimaryAggregatorResults(AggregatorResultStorage dstStorage, AggregatorOutputCollector theAggregatorDiskOutputCollector, AggregatorOutputCollector theAggregatorStorageOutputCollector, MutableLong theSpilledBytesCount) {
        dstStorage.createArray();
        if (this.dumpPrimaryDiskData(dstStorage, theAggregatorDiskOutputCollector, theSpilledBytesCount)) {
            return;
        }
        this.dumpPrimaryMemoryData(theAggregatorStorageOutputCollector);
    }

    private void dumpSecondaryAggregatorResults(AggregatorResultStorage dstStorage) {
        dstStorage.createArray();
        int aRequiredBlocksCount = this.mDataMemoryBlockChain.getActualBlocksCount() * this.mAggregationPolicy.aggregationStrategiesCount();
        if (this.onlyMemory() && dstStorage.acquireBlocks(aRequiredBlocksCount)) {
            this.dumpSecondaryMemoryData();
        } else {
            this.dumpSecondaryDiskData();
            dstStorage.passSpilledFile(this.mDataMemoryBlockChain);
        }
    }

    private void dumpSecondaryMemoryData() {
        ConventionalHashTableTapeIterator aTapeIterator = super.getTapeIterator();
        while (aTapeIterator.hasNext()) {
            try {
                this.mResultArray.append((ByteReader)aTapeIterator.next());
            }
            catch (IOException theE) {
                throw Utilities.rethrow(theE);
            }
        }
        this.closeIterator(aTapeIterator);
        this.disposeMemory();
    }

    private void dumpPrimaryMemoryData(AggregatorOutputCollector theAggregatorStorageOutputCollector) {
        this.mAssembler.assembleAll(this.mAggregatorMainIterator, theAggregatorStorageOutputCollector);
    }

    private boolean dumpPrimaryDiskData(AggregatorResultStorage dstStorage, AggregatorOutputCollector theAggregatorOutputCollector, MutableLong theSpilledBytesCount) {
        if (!this.onlyMemory() || !dstStorage.acquireBlocks(this.mDataMemoryBlockChain.getActualBlocksCount())) {
            theSpilledBytesCount.setValue(0L);
            this.executeSpill(theAggregatorOutputCollector);
            this.mDataMemoryBlockChain.setTotalSpilledBytes(theSpilledBytesCount.getValue());
            dstStorage.passSpilledFile(this.mDataMemoryBlockChain);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpSecondaryDiskData() {
        try {
            this.mOperationTracker.onStart(OperationType.SPILLING);
            File dumpFile = this.openDiskWriter(this.mSKDiskDataBlocksWriter);
            ConventionalHashTableTapeIterator aTapeIterator = super.getTapeIterator();
            try {
                long aElementsCount = 0L;
                this.mDumpedBytesCount.setValue(0L);
                while (aTapeIterator.hasNext()) {
                    this.mSpillingSecondaryDumpDiskOutputCollector.collect((HashTableTapeElementInput)aTapeIterator.next());
                    ++aElementsCount;
                }
                this.mDataMemoryBlockChain.reset();
                this.mDataMemoryBlockChain.setTotalElementsCount(aElementsCount);
                this.mDataMemoryBlockChain.setTotalSpilledBytes(this.mDumpedBytesCount.getValue());
            }
            finally {
                this.mSKDiskDataBlocksWriter.close();
                this.closeIterator(aTapeIterator);
                this.deleteFile(this.mDataMemoryBlockChain.getSpilledFile());
                this.mDataMemoryBlockChain.setSpilledFile(dumpFile);
            }
        }
        finally {
            this.mOperationTracker.onDone(OperationType.SPILLING);
        }
    }

    private void closeIterator(TapeIterator theTapeIterator) {
        theTapeIterator.close();
    }

    private void disposeMemory() {
        this.mDataMemoryBlockChain.dispose();
        this.mPartitionsArea.disposeMemory();
    }

    private boolean onlyMemory() {
        return this.mDataMemoryBlockChain.getTotalSpilledBytes() == 0L;
    }

    private SingleSKDiskResultTapeIterator createSKDiskResultIterator() {
        return new SingleSKDiskResultTapeIterator(this.mMemoryContext, this.mSKAssembler, this.mSkAggregator, this.mSkDiskSpillingReader, this.mPKDiskAggregatorMainIterator, this.mDataAreaAccessor, this.mAggregationPolicyObjectSupplier, this.mMemoryBlockChainFactory);
    }

    private SingleSKResultTapeIterator createSKMemoryResultIterator() {
        return new SingleSKResultTapeIterator(this.mMemoryContext, this.mSKAssembler, this.mSkAggregator, this.mPKMemoryAggregatorMainIterator, this.mAggregationPolicyObjectSupplier);
    }

    private SecondaryKeyAggregator createSKAggregator(int theSpillingBufferSize, MemoryContext theMemoryContext, int thePartitionCount, OperationTracker theOperationTracker) {
        return new SecondaryKeyAggregator(theSpillingBufferSize, theMemoryContext, thePartitionCount, theOperationTracker);
    }

    protected AggregatorAssembler createSingleIteratorAssembler(MemoryContext theMemoryContext) {
        return new SingleIteratorAggregatorAssembler(theMemoryContext, this.mDataAreaAccessor);
    }

    private ConventionalSegmentedTapeIterator createSKDiskAggregatorIterator() {
        return new AggregatorDiskTapeIterator(this.mSkDiskSpillingReader, this.createDiskInputIterator(this.mMemoryBlockChainFactory, this.mSkDiskSpillingReader, this.mMemoryContext));
    }

    private HashTableMultiInputIterator createDiskInputIterator(MemoryBlockChainFactory theFactory, DefaultFileReader theDiskInput, MemoryContext theMemoryContext) {
        return new HashTableDiskMultiInputIterator(theFactory, theDiskInput, theMemoryContext);
    }

    private SpillingDumpDiskOutputCollector createSpillingDumpDiskOutputCollector(MutableLong theDumpedBytesCounter, OperationTracker theOperationTracker) {
        return this.createSpillingDumpDiskOutputCollector(this.mDiskDataBlocksWriter, theDumpedBytesCounter, theOperationTracker);
    }

    private SpillingDumpDiskOutputCollector createSpillingDumpDiskOutputCollector(FileWriter theDiskDataBlocksWriter, MutableLong theDumpedBytesCounter, OperationTracker theOperationTracker) {
        return new SpillingDumpDiskOutputCollector(theDiskDataBlocksWriter, theDumpedBytesCounter, theOperationTracker);
    }

    private boolean hasSecondaryAggregationPolicy() {
        return this.mAggregationPolicy != null && this.mAggregationPolicy.aggregationStrategiesCount() > 0;
    }

    private void validateAggregatorState() {
        if (this.mState == State.ITERATION) {
            throw new IllegalStateException("Can't re-iterate over non-dumped aggregator");
        }
        this.mState = State.ITERATION;
    }

    private void validateSecondaryAggregationPolicy(AggregationPolicy theAggregationPolicy) {
        if (theAggregationPolicy == null || theAggregationPolicy.aggregationStrategiesCount() <= 0) {
            throw new IllegalStateException("Invalid aggregation policy - no strategies");
        }
        for (int i = 0; i < theAggregationPolicy.aggregationStrategiesCount(); ++i) {
            this.validateAggregationStrategy(theAggregationPolicy.get(i));
        }
        if (this.mFunctor != null) {
            throw new IllegalStateException("Can't set secondary aggregation policy while primary functor is being set");
        }
        if (this.mPrimaryKeysUniqueness) {
            throw new IllegalStateException("Can't set secondary aggregation policy while primary key uniqueness is being set");
        }
    }

    private void validateAggregationStrategy(AggregationStrategy theAggregationStrategy) {
        this.validateEmptySKComparator(theAggregationStrategy);
        this.validateSKFunctor(theAggregationStrategy.isKeyUnique(), theAggregationStrategy.getFunctor());
        if (theAggregationStrategy.isInputAggregated()) {
            if (theAggregationStrategy.getComparator() == null) {
                throw new IllegalStateException("Invalid aggregation strategy: aggregated input can be used only with specified comparator");
            }
            if (!theAggregationStrategy.isKeyUnique()) {
                throw new IllegalStateException("Invalid aggregation strategy aggregated input can be used only to emit unique keys");
            }
            this.validateFunctor(theAggregationStrategy);
        }
    }

    private void validateEmptySKComparator(AggregationStrategy theAggregationStrategy) {
        if (theAggregationStrategy.getComparator() == null) {
            if (theAggregationStrategy.isInputAggregated()) {
                throw new IllegalStateException("Input aggregated is not supported when SK-comparator is empty");
            }
            if (theAggregationStrategy.isKeyUnique()) {
                throw new IllegalStateException("Key uniqueness is not supported when SK-comparator is empty");
            }
            this.validateFunctor(theAggregationStrategy);
        }
    }

    private void validateFunctor(AggregationStrategy theAggregationStrategy) {
        if (theAggregationStrategy.getFunctor() != null) {
            throw new IllegalStateException("Invalid aggregation strategy aggregated input can be used with functor");
        }
    }

    private void validateSKFunctor(boolean theKeyUniqueness, Functor theFunctor) {
        if (theKeyUniqueness && theFunctor != null) {
            throw new IllegalStateException("Can't set primary key uniqueness while functor is being set");
        }
    }

    private void validateKeyUniquenessAndFunctorCompatibility(boolean theKeyUniqueness, Functor theFunctor) {
        if (!theKeyUniqueness && theFunctor != null && theFunctor.isAssociative()) {
            throw new IllegalStateException("Can't unset primary key uniqueness while associative functor is being set");
        }
        if (theKeyUniqueness && theFunctor != null && !theFunctor.isAssociative()) {
            throw new IllegalStateException("Can't set primary key uniqueness while non associative functor is being set");
        }
        if (theKeyUniqueness && this.hasSecondaryAggregationPolicy()) {
            throw new IllegalStateException("Can't set primary key uniqueness while secondary aggregation policy is being set");
        }
        if (theFunctor != null && this.hasSecondaryAggregationPolicy()) {
            throw new IllegalStateException("Can't set primary functor while secondary aggregation policy is being set");
        }
    }

    static enum State {
        AGGREGATION,
        ITERATION,
        DUMPED;

    }
}

