/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure;

import com.complexible.memory.structure.OperationType;

public interface OperationTracker {
    public static final OperationTracker DEFAULT = new OperationTracker(){};

    default public void onStart(OperationType theOperationType) {
    }

    default public void onNext(OperationType theOperationType) {
    }

    default public void onSpilling(long theBytes) {
        this.onNext(OperationType.SPILLING);
    }

    default public boolean onAcquiringMemory(long theBytes) {
        return true;
    }

    default public void onMemoryAcquired(long theBytes) {
    }

    default public void onMemoryReleased(long theBytes) {
    }

    default public void onDone(OperationType theOperationType) {
    }

    public static class Delegate
    implements OperationTracker {
        private final OperationTracker mSDelegate;

        public Delegate(OperationTracker theTracker) {
            this.mSDelegate = theTracker;
        }

        @Override
        public void onStart(OperationType theOperationType) {
            this.mSDelegate.onStart(theOperationType);
        }

        @Override
        public void onNext(OperationType theOperationType) {
            this.mSDelegate.onNext(theOperationType);
        }

        @Override
        public void onSpilling(long theBytes) {
            this.mSDelegate.onSpilling(theBytes);
        }

        @Override
        public void onDone(OperationType theOperationType) {
            this.mSDelegate.onDone(theOperationType);
        }

        @Override
        public boolean onAcquiringMemory(long theBytes) {
            return this.mSDelegate.onAcquiringMemory(theBytes);
        }

        @Override
        public void onMemoryAcquired(long theBytes) {
            this.mSDelegate.onMemoryAcquired(theBytes);
        }

        @Override
        public void onMemoryReleased(long theBytes) {
            this.mSDelegate.onMemoryReleased(theBytes);
        }
    }
}

