/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.structure;

import com.complexible.common.base.Disposable;
import com.complexible.common.base.Disposables;
import java.util.NoSuchElementException;

public abstract class BaseIterator
implements Disposable {
    protected STATE mState = STATE.INITIAL;
    private boolean mHasNextResult;

    protected final void iterateNext() {
        if (this.mState == STATE.FINISHED) {
            throw new NoSuchElementException();
        }
        if (this.hasNext()) {
            this.setInitialState();
            return;
        }
        this.finishIteration();
        throw new NoSuchElementException();
    }

    public final boolean hasNext() {
        if (this.mState != STATE.INITIAL) {
            return this.mHasNextResult;
        }
        this.mState = STATE.PENDING;
        this.mHasNextResult = this.hasNext0();
        return this.mHasNextResult;
    }

    public final void reset() {
        this.setInitialState();
        this.reset0();
    }

    public final void close() {
        this.setInitialState();
        this.close0();
    }

    public final void dispose() {
        this.setInitialState();
        this.dispose0();
        Disposables.markReleased((Object)this);
    }

    private void finishIteration() {
        this.mHasNextResult = false;
        this.mState = STATE.FINISHED;
    }

    protected final void setInitialState() {
        this.mState = STATE.INITIAL;
    }

    protected void dispose0() {
        this.reset0();
    }

    protected abstract void reset0();

    protected abstract boolean hasNext0();

    protected abstract void close0();

    protected static enum STATE {
        INITIAL,
        PENDING,
        FINISHED;

    }
}

