/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.memoryblock;

import com.complexible.common.unsafe.UnsafeUtil;
import com.complexible.memory.accessor.ByteMemoryAccessor;
import com.complexible.memory.accessor.impl.SystemMemoryAccessor;
import java.util.Arrays;

public final class UnsafeByteArrayMemoryAccessor
implements ByteMemoryAccessor {
    private byte[] mMemory;

    public UnsafeByteArrayMemoryAccessor(byte[] memory) {
        this.mMemory = memory;
    }

    @Override
    public byte[] array() {
        return this.mMemory;
    }

    @Override
    public boolean getBoolean(long theAddress) {
        return this.getByte(theAddress) > 0;
    }

    @Override
    public void putBoolean(long theAddress, boolean theValue) {
        this.putByte(theAddress, theValue ? (byte)1 : 0);
    }

    @Override
    public byte getByte(long theAddress) {
        return UnsafeUtil.UNSAFE.getByte(this.mMemory, UnsafeByteArrayMemoryAccessor.toNativeAddress(theAddress));
    }

    @Override
    public void putByte(long theAddress, byte theValue) {
        UnsafeUtil.UNSAFE.putByte(this.mMemory, UnsafeByteArrayMemoryAccessor.toNativeAddress(theAddress), theValue);
    }

    @Override
    public char getChar(long theAddress) {
        return UnsafeUtil.UNSAFE.getChar(this.mMemory, UnsafeByteArrayMemoryAccessor.toNativeAddress(theAddress));
    }

    @Override
    public void putChar(long theAddress, char theValue) {
        UnsafeUtil.UNSAFE.putChar(this.mMemory, UnsafeByteArrayMemoryAccessor.toNativeAddress(theAddress), theValue);
    }

    @Override
    public short getShort(long theAddress) {
        return UnsafeUtil.UNSAFE.getShort(this.mMemory, UnsafeByteArrayMemoryAccessor.toNativeAddress(theAddress));
    }

    @Override
    public void putShort(long theAddress, short theValue) {
        UnsafeUtil.UNSAFE.putShort(this.mMemory, UnsafeByteArrayMemoryAccessor.toNativeAddress(theAddress), theValue);
    }

    @Override
    public int getInt(long theAddress) {
        return UnsafeUtil.UNSAFE.getInt(this.mMemory, UnsafeByteArrayMemoryAccessor.toNativeAddress(theAddress));
    }

    @Override
    public void putInt(long theAddress, int theValue) {
        UnsafeUtil.UNSAFE.putInt(this.mMemory, UnsafeByteArrayMemoryAccessor.toNativeAddress(theAddress), theValue);
    }

    @Override
    public float getFloat(long theAddress) {
        return UnsafeUtil.UNSAFE.getFloat(this.mMemory, UnsafeByteArrayMemoryAccessor.toNativeAddress(theAddress));
    }

    @Override
    public void putFloat(long theAddress, float theValue) {
        UnsafeUtil.UNSAFE.putFloat(this.mMemory, UnsafeByteArrayMemoryAccessor.toNativeAddress(theAddress), theValue);
    }

    @Override
    public long getLong(long theAddress) {
        return UnsafeUtil.UNSAFE.getLong(this.mMemory, UnsafeByteArrayMemoryAccessor.toNativeAddress(theAddress));
    }

    @Override
    public void putLong(long theAddress, long theValue) {
        UnsafeUtil.UNSAFE.putLong(this.mMemory, UnsafeByteArrayMemoryAccessor.toNativeAddress(theAddress), theValue);
    }

    @Override
    public double getDouble(long theAddress) {
        return UnsafeUtil.UNSAFE.getDouble(this.mMemory, UnsafeByteArrayMemoryAccessor.toNativeAddress(theAddress));
    }

    @Override
    public void putDouble(long theAddress, double theValue) {
        UnsafeUtil.UNSAFE.putDouble(this.mMemory, UnsafeByteArrayMemoryAccessor.toNativeAddress(theAddress), theValue);
    }

    @Override
    public void copyMemory(long theSrcAddress, long theDstAddress, long lengthBytes) {
        UnsafeUtil.UNSAFE.copyMemory(this.mMemory, UnsafeByteArrayMemoryAccessor.toNativeAddress(theSrcAddress), this.mMemory, UnsafeByteArrayMemoryAccessor.toNativeAddress(theDstAddress), lengthBytes);
    }

    @Override
    public void copyFromByteArray(byte[] theSourceArray, int theSrcOffset, long theDstAddress, int theLength) {
        System.arraycopy(theSourceArray, theSrcOffset, this.mMemory, (int)theDstAddress, theLength);
    }

    @Override
    public void copyFromLongArray(long[] theSourceArray, int theSrcOffset, long theDstAddress, int theLength) {
        UnsafeUtil.UNSAFE.copyMemory(theSourceArray, SystemMemoryAccessor.ARRAY_LONG_BASE_OFFSET + theSrcOffset, this.mMemory, UnsafeByteArrayMemoryAccessor.toNativeAddress(theDstAddress), theLength);
    }

    public static void copyFromLongArray(long[] theSourceArray, int theSrcOffset, byte[] theDstMemory, long theDstAddress, int theLength) {
        UnsafeUtil.UNSAFE.copyMemory(theSourceArray, SystemMemoryAccessor.ARRAY_LONG_BASE_OFFSET + theSrcOffset, theDstMemory, UnsafeByteArrayMemoryAccessor.toNativeAddress(theDstAddress), theLength);
    }

    @Override
    public void copyToByteArray(long theSrcAddress, byte[] theDstArray, int theDstOffset, int theLength) {
        System.arraycopy(this.mMemory, (int)theSrcAddress, theDstArray, theDstOffset, theLength);
    }

    @Override
    public void copyToLongArray(long[] theDstArray, long theSrcAddress, long theDstOffset, long theLength) {
        UnsafeUtil.UNSAFE.copyMemory(this.mMemory, UnsafeByteArrayMemoryAccessor.toNativeAddress(theSrcAddress), theDstArray, (long)SystemMemoryAccessor.ARRAY_LONG_BASE_OFFSET + theDstOffset, theLength);
    }

    @Override
    public void copyToCharArray(char[] theDstArray, long theSrcAddress, long theDstOffset, long theLength) {
        UnsafeUtil.UNSAFE.copyMemory(this.mMemory, UnsafeByteArrayMemoryAccessor.toNativeAddress(theSrcAddress), theDstArray, (long)SystemMemoryAccessor.ARRAY_CHAR_BASE_OFFSET + theDstOffset, theLength);
    }

    @Override
    public void setMemory(long theAddress, long theLengthBytes, byte theValue) {
        Arrays.fill(this.mMemory, (int)theAddress, (int)(theAddress + theLengthBytes), theValue);
    }

    @Override
    public void copyToNativeMemory(long theSrcAddress, long theDstAddress, long theLengthBytes) {
        SystemMemoryAccessor.NATIVE_MEMORY.copyFromByteArray(this.mMemory, (int)theSrcAddress, theDstAddress, (int)theLengthBytes);
    }

    public void setMemory(byte[] theMemory) {
        this.mMemory = theMemory;
    }

    @Override
    public void dispose() {
        this.mMemory = null;
    }

    private static long toNativeAddress(long destAddress) {
        return (long)SystemMemoryAccessor.ARRAY_BYTE_BASE_OFFSET + (long)SystemMemoryAccessor.ARRAY_BYTE_INDEX_SCALE * destAddress;
    }
}

