/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.memoryblock;

import com.complexible.common.io.ByteReader;
import com.complexible.common.unsafe.UnsafeUtil;
import com.complexible.memory.accessor.MemoryAccessor;
import com.complexible.memory.accessor.impl.SystemMemoryAccessor;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryType;
import com.complexible.memory.memoryblock.NativePlatformMemoryAccessor;
import com.complexible.memory.util.Utilities;
import com.google.common.base.Preconditions;
import java.io.IOException;

public final class NativeMemoryBlock
implements MemoryBlock {
    private final int mBlockSize;
    private final long mBaseAddress;
    private final long mHeaderAddress;
    private final MemoryAccessor mBlockHeader;

    public NativeMemoryBlock(int blockSize) {
        Preconditions.checkArgument((blockSize >= 32 ? 1 : 0) != 0, (Object)" Block's size shouldn't be less then 32 bytes ");
        this.mBlockSize = blockSize;
        this.mBaseAddress = this.allocateNative(blockSize);
        this.mHeaderAddress = this.allocateNative(40);
        this.mBlockHeader = this.createMemoryAccessor(this.mHeaderAddress);
    }

    @Override
    public MemoryType type() {
        return MemoryType.NATIVE;
    }

    @Override
    public int getBlockSize() {
        return this.mBlockSize;
    }

    @Override
    public void copyFromReader(ByteReader theReader, int theDstOffset, int theLength) {
        try {
            theReader.readNative(this.mBaseAddress + (long)theDstOffset, theLength);
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public void copyFromMemoryBlock(MemoryBlock theSourceMemoryBlock, int theSourceOffset, int theTargetOffset, int theBytesToCopy) {
        SystemMemoryAccessor.NATIVE_MEMORY.copyMemory(((NativeMemoryBlock)theSourceMemoryBlock).mBaseAddress + (long)theSourceOffset, this.mBaseAddress + (long)theTargetOffset, theBytesToCopy);
    }

    @Override
    public int read(byte[] theTargetData, int theTargetOffset, int theSourceOffset, int theLength) {
        SystemMemoryAccessor.NATIVE_MEMORY.copyToByteArray(this.mBaseAddress + (long)theSourceOffset, theTargetData, theTargetOffset, theLength);
        return theLength;
    }

    @Override
    public int read(long theTargetAddress, int theSourceOffset, int theLength) {
        SystemMemoryAccessor.NATIVE_MEMORY.copyMemory(this.mBaseAddress + (long)theSourceOffset, theTargetAddress, theLength);
        return theLength;
    }

    @Override
    public MemoryAccessor getHeader() {
        return this.mBlockHeader;
    }

    @Override
    public void dispose() {
        UnsafeUtil.UNSAFE.freeMemory(this.mBaseAddress);
        UnsafeUtil.UNSAFE.freeMemory(this.mHeaderAddress);
    }

    @Override
    public boolean getBoolean(long theAddress) {
        return SystemMemoryAccessor.NATIVE_MEMORY.getBoolean(this.mBaseAddress + theAddress);
    }

    @Override
    public void putBoolean(long theAddress, boolean theValue) {
        SystemMemoryAccessor.NATIVE_MEMORY.putBoolean(this.mBaseAddress + theAddress, theValue);
    }

    @Override
    public byte getByte(long theAddress) {
        return SystemMemoryAccessor.NATIVE_MEMORY.getByte(this.mBaseAddress + theAddress);
    }

    @Override
    public void putByte(long theAddress, byte theValue) {
        SystemMemoryAccessor.NATIVE_MEMORY.putByte(this.mBaseAddress + theAddress, theValue);
    }

    @Override
    public char getChar(long theAddress) {
        return SystemMemoryAccessor.NATIVE_MEMORY.getChar(this.mBaseAddress + theAddress);
    }

    @Override
    public void putChar(long theAddress, char theValue) {
        SystemMemoryAccessor.NATIVE_MEMORY.putChar(this.mBaseAddress + theAddress, theValue);
    }

    @Override
    public short getShort(long theAddress) {
        return SystemMemoryAccessor.NATIVE_MEMORY.getShort(this.mBaseAddress + theAddress);
    }

    @Override
    public void putShort(long theAddress, short theValue) {
        SystemMemoryAccessor.NATIVE_MEMORY.putShort(this.mBaseAddress + theAddress, theValue);
    }

    @Override
    public int getInt(long theAddress) {
        return SystemMemoryAccessor.NATIVE_MEMORY.getInt(this.mBaseAddress + theAddress);
    }

    @Override
    public void putInt(long theAddress, int theValue) {
        SystemMemoryAccessor.NATIVE_MEMORY.putInt(this.mBaseAddress + theAddress, theValue);
    }

    @Override
    public float getFloat(long theAddress) {
        return SystemMemoryAccessor.NATIVE_MEMORY.getFloat(this.mBaseAddress + theAddress);
    }

    @Override
    public void putFloat(long theAddress, float theValue) {
        SystemMemoryAccessor.NATIVE_MEMORY.putFloat(this.mBaseAddress + theAddress, theValue);
    }

    @Override
    public long getLong(long theAddress) {
        return SystemMemoryAccessor.NATIVE_MEMORY.getLong(this.mBaseAddress + theAddress);
    }

    @Override
    public void putLong(long theAddress, long theValue) {
        SystemMemoryAccessor.NATIVE_MEMORY.putLong(this.mBaseAddress + theAddress, theValue);
    }

    @Override
    public double getDouble(long theAddress) {
        return SystemMemoryAccessor.NATIVE_MEMORY.getDouble(this.mBaseAddress + theAddress);
    }

    @Override
    public void putDouble(long theAddress, double theValue) {
        SystemMemoryAccessor.NATIVE_MEMORY.putDouble(this.mBaseAddress + theAddress, theValue);
    }

    @Override
    public void copyMemory(long theSrcAddress, long theDstAddress, long lengthBytes) {
        SystemMemoryAccessor.NATIVE_MEMORY.copyMemory(this.mBaseAddress + theSrcAddress, this.mBaseAddress + theDstAddress, lengthBytes);
    }

    @Override
    public void copyFromByteArray(byte[] theSourceArray, int theSrcOffset, long theDstAddress, int theLength) {
        SystemMemoryAccessor.NATIVE_MEMORY.copyFromByteArray(theSourceArray, theSrcOffset, this.mBaseAddress + theDstAddress, theLength);
    }

    @Override
    public void copyFromLongArray(long[] theSourceArray, int theSrcOffset, long theDstAddress, int theLength) {
        SystemMemoryAccessor.NATIVE_MEMORY.copyFromLongArray(theSourceArray, theSrcOffset, this.mBaseAddress + theDstAddress, theLength);
    }

    @Override
    public void copyToByteArray(long theSrcAddress, byte[] theDstArray, int theDstOffset, int theLength) {
        SystemMemoryAccessor.NATIVE_MEMORY.copyToByteArray(this.mBaseAddress + theSrcAddress, theDstArray, theDstOffset, theLength);
    }

    @Override
    public void copyToLongArray(long[] theDstArray, long theSrcAddress, long theDstOffset, long theLength) {
        SystemMemoryAccessor.NATIVE_MEMORY.copyToLongArray(theDstArray, this.mBaseAddress + theSrcAddress, theDstOffset, theLength);
    }

    @Override
    public void copyToCharArray(char[] theDstArray, long theSrcAddress, long theDstOffset, long theLength) {
        SystemMemoryAccessor.NATIVE_MEMORY.copyToCharArray(theDstArray, this.mBaseAddress + theSrcAddress, theDstOffset, theLength);
    }

    @Override
    public void copyToNativeMemory(long theSrcAddress, long theDstAddress, long theLengthBytes) {
        SystemMemoryAccessor.NATIVE_MEMORY.copyMemory(this.mBaseAddress + theSrcAddress, theDstAddress, theLengthBytes);
    }

    @Override
    public void setMemory(long theAddress, long theLengthBytes, byte theValue) {
        SystemMemoryAccessor.NATIVE_MEMORY.setMemory(this.mBaseAddress + theAddress, theLengthBytes, theValue);
    }

    private long allocateNative(int theBlockSize) {
        return UnsafeUtil.UNSAFE.allocateMemory(theBlockSize);
    }

    private MemoryAccessor createMemoryAccessor(long theBaseAddress) {
        return new NativePlatformMemoryAccessor(theBaseAddress);
    }
}

