/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.memoryblock;

import com.complexible.memory.accessor.ByteAccessor;
import com.complexible.memory.accessor.MemoryAccessor;
import com.complexible.memory.accessor.impl.ByteOrderUtil;
import com.complexible.memory.accessor.impl.SystemMemoryAccessor;

public final class NativeMemoryAccessor
implements MemoryAccessor {
    private final long mBaseAddress;
    private final boolean mUseBigEndian;

    public NativeMemoryAccessor(long theBaseAddress, boolean useBigEndian) {
        this.mUseBigEndian = useBigEndian;
        this.mBaseAddress = theBaseAddress;
    }

    @Override
    public boolean getBoolean(long theAddress) {
        return SystemMemoryAccessor.NATIVE_MEMORY.getBoolean(this.mBaseAddress + theAddress);
    }

    @Override
    public void putBoolean(long theAddress, boolean theValue) {
        SystemMemoryAccessor.NATIVE_MEMORY.putBoolean(this.mBaseAddress + theAddress, theValue);
    }

    @Override
    public byte getByte(long theAddress) {
        return SystemMemoryAccessor.NATIVE_MEMORY.getByte(this.mBaseAddress + theAddress);
    }

    @Override
    public void putByte(long theAddress, byte theValue) {
        SystemMemoryAccessor.NATIVE_MEMORY.putByte(this.mBaseAddress + theAddress, theValue);
    }

    @Override
    public char getChar(long theAddress) {
        return ByteOrderUtil.readChar(ByteAccessor.MEMORY_ACCESSOR_BYTE_ACCESSOR, SystemMemoryAccessor.NATIVE_MEMORY, this.mBaseAddress + theAddress, this.mUseBigEndian);
    }

    @Override
    public void putChar(long theAddress, char theValue) {
        ByteOrderUtil.writeChar(ByteAccessor.MEMORY_ACCESSOR_BYTE_ACCESSOR, SystemMemoryAccessor.NATIVE_MEMORY, this.mBaseAddress + theAddress, theValue, this.mUseBigEndian);
    }

    @Override
    public short getShort(long theAddress) {
        return ByteOrderUtil.readShort(ByteAccessor.MEMORY_ACCESSOR_BYTE_ACCESSOR, SystemMemoryAccessor.NATIVE_MEMORY, this.mBaseAddress + theAddress, this.mUseBigEndian);
    }

    @Override
    public void putShort(long theAddress, short theValue) {
        ByteOrderUtil.writeShort(ByteAccessor.MEMORY_ACCESSOR_BYTE_ACCESSOR, SystemMemoryAccessor.NATIVE_MEMORY, this.mBaseAddress + theAddress, theValue, this.mUseBigEndian);
    }

    @Override
    public int getInt(long theAddress) {
        return ByteOrderUtil.readInt(ByteAccessor.MEMORY_ACCESSOR_BYTE_ACCESSOR, SystemMemoryAccessor.NATIVE_MEMORY, this.mBaseAddress + theAddress, this.mUseBigEndian);
    }

    @Override
    public void putInt(long theAddress, int theValue) {
        ByteOrderUtil.writeInt(ByteAccessor.MEMORY_ACCESSOR_BYTE_ACCESSOR, SystemMemoryAccessor.NATIVE_MEMORY, this.mBaseAddress + theAddress, theValue, this.mUseBigEndian);
    }

    @Override
    public float getFloat(long theAddress) {
        return ByteOrderUtil.readFloat(ByteAccessor.MEMORY_ACCESSOR_BYTE_ACCESSOR, SystemMemoryAccessor.NATIVE_MEMORY, this.mBaseAddress + theAddress, this.mUseBigEndian);
    }

    @Override
    public void putFloat(long theAddress, float theValue) {
        ByteOrderUtil.writeFloat(ByteAccessor.MEMORY_ACCESSOR_BYTE_ACCESSOR, SystemMemoryAccessor.NATIVE_MEMORY, this.mBaseAddress + theAddress, theValue, this.mUseBigEndian);
    }

    @Override
    public long getLong(long theAddress) {
        return ByteOrderUtil.readLong(ByteAccessor.MEMORY_ACCESSOR_BYTE_ACCESSOR, SystemMemoryAccessor.NATIVE_MEMORY, this.mBaseAddress + theAddress, this.mUseBigEndian);
    }

    @Override
    public void putLong(long theAddress, long theValue) {
        ByteOrderUtil.writeLong(ByteAccessor.MEMORY_ACCESSOR_BYTE_ACCESSOR, SystemMemoryAccessor.NATIVE_MEMORY, this.mBaseAddress + theAddress, theValue, this.mUseBigEndian);
    }

    @Override
    public double getDouble(long theAddress) {
        return ByteOrderUtil.readDouble(ByteAccessor.MEMORY_ACCESSOR_BYTE_ACCESSOR, SystemMemoryAccessor.NATIVE_MEMORY, this.mBaseAddress + theAddress, this.mUseBigEndian);
    }

    @Override
    public void putDouble(long theAddress, double theValue) {
        ByteOrderUtil.writeDouble(ByteAccessor.MEMORY_ACCESSOR_BYTE_ACCESSOR, SystemMemoryAccessor.NATIVE_MEMORY, this.mBaseAddress + theAddress, theValue, this.mUseBigEndian);
    }

    @Override
    public void copyMemory(long theSrcAddress, long theDstAddress, long lengthBytes) {
        SystemMemoryAccessor.NATIVE_MEMORY.copyMemory(this.mBaseAddress + theSrcAddress, this.mBaseAddress + theDstAddress, lengthBytes);
    }

    @Override
    public void copyFromByteArray(byte[] theSourceArray, int theSrcOffset, long theDstAddress, int theLength) {
        SystemMemoryAccessor.NATIVE_MEMORY.copyFromByteArray(theSourceArray, theSrcOffset, this.mBaseAddress + theDstAddress, theLength);
    }

    @Override
    public void copyFromLongArray(long[] theSourceArray, int theSrcOffset, long theDstAddress, int theLength) {
        SystemMemoryAccessor.NATIVE_MEMORY.copyFromLongArray(theSourceArray, theSrcOffset, theDstAddress, theLength);
    }

    @Override
    public void copyToByteArray(long theSrcAddress, byte[] theDstArray, int theDstOffset, int theLength) {
        SystemMemoryAccessor.NATIVE_MEMORY.copyToByteArray(this.mBaseAddress + theSrcAddress, theDstArray, theDstOffset, theLength);
    }

    @Override
    public void copyToLongArray(long[] theDstArray, long theSrcAddress, long theDstOffset, long theLength) {
        SystemMemoryAccessor.NATIVE_MEMORY.copyToLongArray(theDstArray, this.mBaseAddress + theSrcAddress, theDstOffset, theLength);
    }

    @Override
    public void copyToCharArray(char[] theDstArray, long theSrcAddress, long theDstOffset, long theLength) {
        SystemMemoryAccessor.NATIVE_MEMORY.copyToCharArray(theDstArray, this.mBaseAddress + theSrcAddress, theDstOffset, theLength);
    }

    @Override
    public void copyToNativeMemory(long theSrcAddress, long theDstAddress, long theLengthBytes) {
        SystemMemoryAccessor.NATIVE_MEMORY.copyMemory(this.mBaseAddress + theSrcAddress, theDstAddress, theLengthBytes);
    }

    @Override
    public void setMemory(long theAddress, long theLengthBytes, byte theValue) {
        SystemMemoryAccessor.NATIVE_MEMORY.setMemory(this.mBaseAddress + theAddress, theLengthBytes, theValue);
    }
}

