/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.memoryblock;

import com.complexible.common.base.Option;
import com.complexible.common.base.Options;
import com.google.common.collect.Maps;
import java.util.Map;

public class MemoryOptions {
    private static Map<String, Option> OPTIONS = Maps.newHashMap();
    public static final Option<Integer> SPILLING_BUF = MemoryOptions.createOption("spilling.buffer.size", 8192);
    public static final int BLOCK_SIZE_DEFAULT = 32768;
    public static final Option<String> BLOCK_SIZE = MemoryOptions.createOption("memory.managed.block.size", String.valueOf(32768));
    public static final Option<Boolean> ALLOCATE_IMMEDIATELY = MemoryOptions.createOption("memory.managed.allocate.immediately", true);
    public static final Option<Boolean> FAIL_OOM_DURING_INIT = MemoryOptions.createOption("memory.managed.allocate.oom.init.fail", true);
    public static final long HASH_TABLE_RESET_THRESHOLD = 64000L;
    private final Options mOptions = Options.create();

    private static <T> Option<T> createOption(String theName, T theDefault) {
        Option aOption = Option.create((String)theName, theDefault);
        OPTIONS.put(theName, aOption);
        return aOption;
    }

    public static MemoryOptions standard() {
        return new MemoryOptions();
    }

    private MemoryOptions() {
    }

    public <V> V get(Option<V> theOption) {
        return (V)this.mOptions.get(theOption);
    }
}

