/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.memoryblock;

import com.complexible.common.io.ByteReader;
import com.complexible.common.unsafe.UnsafeUtil;
import com.complexible.memory.accessor.MemoryAccessor;
import com.complexible.memory.accessor.impl.SystemMemoryAccessor;
import com.complexible.memory.memoryblock.ByteArrayMemoryAccessor;
import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryType;
import com.complexible.memory.memoryblock.UnsafeByteArrayMemoryAccessor;
import com.complexible.memory.util.Utilities;
import com.google.common.base.Preconditions;
import java.io.IOException;

public final class HeapMemoryBlock
implements MemoryBlock {
    private byte[] mData;
    private final MemoryAccessor mBlockHeader;
    private final MemoryAccessor mBaseMemoryAccessor;

    public HeapMemoryBlock(int theBlockSize) {
        Preconditions.checkArgument((theBlockSize >= 32 ? 1 : 0) != 0, (Object)" Block's size shouldn't be less then 32 bytes ");
        this.mData = new byte[theBlockSize];
        this.mBaseMemoryAccessor = this.createMemoryAccessor(this.mData);
        this.mBlockHeader = this.createMemoryAccessor(new byte[40]);
    }

    @Override
    public MemoryType type() {
        return MemoryType.HEAP;
    }

    @Override
    public int getBlockSize() {
        return this.mData.length;
    }

    @Override
    public void copyFromReader(ByteReader theReader, int theDstOffset, int theLength) {
        try {
            theReader.read(this.mData, theDstOffset, theLength);
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public void copyFromMemoryBlock(MemoryBlock theSourceMemoryBlock, int theSourceOffset, int theTargetOffset, int theBytesToCopy) {
        System.arraycopy(((HeapMemoryBlock)theSourceMemoryBlock).mData, theSourceOffset, this.mData, theTargetOffset, theBytesToCopy);
    }

    @Override
    public int read(byte[] theTargetData, int theTargetOffset, int theSourceOffset, int theLength) {
        System.arraycopy(this.mData, theSourceOffset, theTargetData, theTargetOffset, theLength);
        return theLength;
    }

    @Override
    public int read(long theTargetAddress, int theSourceOffset, int theLength) {
        SystemMemoryAccessor.NATIVE_MEMORY.copyFromByteArray(this.mData, theSourceOffset, theTargetAddress, theLength);
        return theLength;
    }

    @Override
    public MemoryAccessor getHeader() {
        return this.mBlockHeader;
    }

    @Override
    public void dispose() {
        this.mData = null;
        this.mBlockHeader.dispose();
        this.mBaseMemoryAccessor.dispose();
    }

    @Override
    public boolean getBoolean(long theAddress) {
        return this.mBaseMemoryAccessor.getBoolean(theAddress);
    }

    @Override
    public void putBoolean(long theAddress, boolean theValue) {
        this.mBaseMemoryAccessor.putBoolean(theAddress, theValue);
    }

    @Override
    public byte getByte(long theAddress) {
        return this.mBaseMemoryAccessor.getByte(theAddress);
    }

    @Override
    public void putByte(long theAddress, byte theValue) {
        this.mBaseMemoryAccessor.putByte(theAddress, theValue);
    }

    @Override
    public char getChar(long theAddress) {
        return this.mBaseMemoryAccessor.getChar(theAddress);
    }

    @Override
    public void putChar(long theAddress, char theValue) {
        this.mBaseMemoryAccessor.putChar(theAddress, theValue);
    }

    @Override
    public short getShort(long theAddress) {
        return this.mBaseMemoryAccessor.getShort(theAddress);
    }

    @Override
    public void putShort(long theAddress, short theValue) {
        this.mBaseMemoryAccessor.putShort(theAddress, theValue);
    }

    @Override
    public int getInt(long theAddress) {
        return this.mBaseMemoryAccessor.getInt(theAddress);
    }

    @Override
    public void putInt(long theAddress, int theValue) {
        this.mBaseMemoryAccessor.putInt(theAddress, theValue);
    }

    @Override
    public float getFloat(long theAddress) {
        return this.mBaseMemoryAccessor.getFloat(theAddress);
    }

    @Override
    public void putFloat(long theAddress, float theValue) {
        this.mBaseMemoryAccessor.putFloat(theAddress, theValue);
    }

    @Override
    public long getLong(long theAddress) {
        return this.mBaseMemoryAccessor.getLong(theAddress);
    }

    @Override
    public void putLong(long theAddress, long theValue) {
        this.mBaseMemoryAccessor.putLong(theAddress, theValue);
    }

    @Override
    public double getDouble(long theAddress) {
        return this.mBaseMemoryAccessor.getDouble(theAddress);
    }

    @Override
    public void putDouble(long theAddress, double theValue) {
        this.mBaseMemoryAccessor.putDouble(theAddress, theValue);
    }

    @Override
    public void copyMemory(long theSrcAddress, long theDstAddress, long lengthBytes) {
        this.mBaseMemoryAccessor.copyMemory(theSrcAddress, theDstAddress, lengthBytes);
    }

    @Override
    public void copyFromByteArray(byte[] theSourceArray, int theSrcOffset, long theDstAddress, int theLength) {
        this.mBaseMemoryAccessor.copyFromByteArray(theSourceArray, theSrcOffset, theDstAddress, theLength);
    }

    @Override
    public void copyFromLongArray(long[] theSourceArray, int theSrcOffset, long theDstAddress, int theLength) {
        this.mBaseMemoryAccessor.copyFromLongArray(theSourceArray, theSrcOffset, theDstAddress, theLength);
    }

    @Override
    public void copyToByteArray(long theSrcAddress, byte[] theDstArray, int theDstOffset, int theLength) {
        this.mBaseMemoryAccessor.copyToByteArray(theSrcAddress, theDstArray, theDstOffset, theLength);
    }

    @Override
    public void copyToLongArray(long[] theDstArray, long theSrcAddress, long theDstOffset, long theLength) {
        this.mBaseMemoryAccessor.copyToLongArray(theDstArray, theSrcAddress, theDstOffset, theLength);
    }

    @Override
    public void copyToCharArray(char[] theDstArray, long theSrcAddress, long theDstOffset, long theLength) {
        this.mBaseMemoryAccessor.copyToCharArray(theDstArray, theSrcAddress, theDstOffset, theLength);
    }

    @Override
    public void copyToNativeMemory(long theSrcAddress, long theDstAddress, long theLengthBytes) {
        this.mBaseMemoryAccessor.copyToNativeMemory(theSrcAddress, theDstAddress, theLengthBytes);
    }

    @Override
    public void setMemory(long theAddress, long theLengthBytes, byte theValue) {
        this.mBaseMemoryAccessor.setMemory(theAddress, theLengthBytes, theValue);
    }

    private MemoryAccessor createMemoryAccessor(byte[] theBlock) {
        return UnsafeUtil.UNSAFE_AVAILABLE ? new UnsafeByteArrayMemoryAccessor(theBlock) : new ByteArrayMemoryAccessor(theBlock);
    }
}

