/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.memoryblock;

import com.complexible.memory.memoryblock.MemoryBlock;
import com.complexible.memory.memoryblock.MemoryBlockChain;
import com.complexible.memory.memoryblock.MemoryBlockPool;
import com.complexible.memory.memoryblock.MemoryContext;
import com.complexible.memory.structure.OperationTracker;
import com.complexible.memory.util.SpillingUtil;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Arrays;

public final class DefaultMemoryBlockChain
implements MemoryBlockChain {
    private File mFile;
    private int mOffset;
    private int mBlockIndex;
    private long mPayLoad;
    private int mActualBlocksCount;
    private long mTotalSpilledBytes;
    private long mTotalElementsCount;
    private long mMemoryElementsCount;
    private MemoryBlock currentBlock;
    private MemoryBlock[] mChain = new MemoryBlock[4];
    private int mChainLength;
    private final MemoryContext mMemoryContext;
    private final long mTotalBlockSize;
    private long mTotalSpilledElementsCount;
    private final OperationTracker mOperationTracker;

    DefaultMemoryBlockChain(MemoryContext memoryContext, OperationTracker theOperationTracker) {
        this.mOperationTracker = theOperationTracker;
        this.mMemoryContext = memoryContext;
        this.mTotalBlockSize = MemoryBlock.computeTotalBlockSize(this.mMemoryContext.getBlockSize());
        this.reset();
    }

    public MemoryContext getMemoryContext() {
        return this.mMemoryContext;
    }

    private MemoryBlock fetchNextFromPool() {
        if (!this.mOperationTracker.onAcquiringMemory(this.mTotalBlockSize)) {
            return null;
        }
        MemoryBlock aMemoryBlock = this.mMemoryContext.getMemoryBlockPool().getNextMemoryBlock();
        if (aMemoryBlock == null) {
            this.mOperationTracker.onMemoryReleased(this.mTotalBlockSize);
        } else {
            this.mOperationTracker.onMemoryAcquired(this.mTotalBlockSize);
        }
        return aMemoryBlock;
    }

    @Override
    public boolean acquireNext() {
        this.currentBlock = this.fetchNextFromPool();
        if (this.currentBlock == null) {
            this.setCurrentBlock(0);
            return false;
        }
        this.add(this.currentBlock);
        this.setCurrentBlock(this.mChainLength - 1);
        return true;
    }

    @Override
    public boolean checkNext() {
        if (this.currentIndex() < this.size() - 1) {
            return true;
        }
        MemoryBlock aMemoryBlock = this.fetchNextFromPool();
        if (aMemoryBlock == null) {
            return false;
        }
        this.add(aMemoryBlock);
        if (this.currentBlock == null && this.mBlockIndex < this.mChain.length) {
            this.currentBlock = this.mChain[this.mBlockIndex];
            return true;
        }
        return true;
    }

    private MemoryBlock removeInternal(int theIndex) {
        Preconditions.checkState((this.mChainLength >= 0 ? 1 : 0) != 0);
        MemoryBlock aMemoryBlock = this.mChain[theIndex];
        --this.mChainLength;
        if (this.mChainLength > theIndex) {
            System.arraycopy(this.mChain, theIndex + 1, this.mChain, theIndex, this.mChainLength - theIndex);
        }
        this.mChain[this.mChainLength] = null;
        return aMemoryBlock;
    }

    @Override
    public MemoryBlock remove(int theIndex) {
        MemoryBlock ret = this.removeInternal(theIndex);
        this.setInitialState();
        return ret;
    }

    @Override
    public MemoryBlock pop() {
        return this.removeInternal(0);
    }

    @Override
    public void chop() {
        this.releaseBlock(this.removeInternal(this.mChainLength - 1));
    }

    @Override
    public boolean obtainNext() {
        return this.gotoNext() || this.acquireNext();
    }

    @Override
    public MemoryBlock current() {
        return this.currentBlock;
    }

    @Override
    public int currentIndex() {
        return this.mBlockIndex;
    }

    @Override
    public boolean isEmpty() {
        return this.mChainLength == 0;
    }

    @Override
    public int currentBlockOffset() {
        return this.mOffset;
    }

    @Override
    public long getTotalElementsCount() {
        return this.mTotalElementsCount;
    }

    @Override
    public void setCurrentBlockOffset(int theOffset) {
        this.mOffset = theOffset;
    }

    @Override
    public void setActualBlocksCount(int theActualBlocksCount) {
        this.mActualBlocksCount = theActualBlocksCount;
    }

    @Override
    public void setMemoryElementsCount(long theMemoryElementsCount) {
        this.mMemoryElementsCount = theMemoryElementsCount;
    }

    @Override
    public long getMemoryElementsCount() {
        return this.mMemoryElementsCount;
    }

    @Override
    public long getTotalSpilledBytes() {
        return this.mTotalSpilledBytes;
    }

    @Override
    public void incrementTotalSpilledBytes(long theSpilledBytes) {
        this.mTotalSpilledBytes += theSpilledBytes;
    }

    @Override
    public void incrementActualBlocksCount() {
        ++this.mActualBlocksCount;
    }

    @Override
    public void incrementMemoryElementsCount() {
        ++this.mMemoryElementsCount;
    }

    @Override
    public void incrementTotalElementsCount() {
        ++this.mTotalElementsCount;
    }

    @Override
    public void incrementCurrentBlockIndex() {
        this.setCurrentBlock(this.currentIndex() + 1);
    }

    @Override
    public void setTotalElementsCount(long theTotalElementsCount) {
        this.mTotalElementsCount = theTotalElementsCount;
    }

    @Override
    public void setTotalSpilledElementsCount(long theTotalSpilledElementsCount) {
        this.mTotalSpilledElementsCount = theTotalSpilledElementsCount;
    }

    @Override
    public long getTotalSpilledElementsCount() {
        return this.mTotalSpilledElementsCount;
    }

    @Override
    public void setTotalSpilledBytes(long theSpilledBytes) {
        this.mTotalSpilledBytes = theSpilledBytes;
    }

    @Override
    public void setPayLoad(long thePayLoad) {
        this.mPayLoad = thePayLoad;
    }

    @Override
    public long getPayLoad() {
        return this.mPayLoad;
    }

    @Override
    public void releaseUnusedBlocks() {
        while (this.mActualBlocksCount < this.size() - 1) {
            this.releaseBlock(this.removeInternal(this.mChainLength - 1));
        }
    }

    @Override
    public int getActualBlocksCount() {
        return this.mActualBlocksCount;
    }

    @Override
    public void setCurrentBlock(int idx) {
        this.mBlockIndex = idx;
        this.currentBlock = this.mBlockIndex >= 0 && this.mBlockIndex < this.mChainLength ? this.mChain[this.mBlockIndex] : null;
    }

    @Override
    public MemoryBlock get(int blockIndex) {
        return this.mChain[blockIndex];
    }

    private int newCapacity(int minCapacity) {
        int oldCapacity = this.mChain.length;
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        int maxArraySize = 0x7FFFFFF7;
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        if (newCapacity > 0x7FFFFFF7) {
            newCapacity = 0x7FFFFFF7;
        }
        return Math.max(newCapacity, minCapacity);
    }

    @Override
    public void add(MemoryBlock element) {
        if (this.mChainLength == this.mChain.length) {
            this.mChain = Arrays.copyOf(this.mChain, this.newCapacity(this.mChain.length + 1));
        }
        this.mChain[this.mChainLength++] = element;
    }

    @Override
    public File getSpilledFile() {
        return this.mFile;
    }

    @Override
    public void setSpilledFile(File theSpilledFile) {
        this.mFile = theSpilledFile;
    }

    @Override
    public boolean gotoNext() {
        if (this.mBlockIndex >= this.mChainLength - 1) {
            return false;
        }
        ++this.mBlockIndex;
        this.currentBlock = this.mChain[this.mBlockIndex];
        return true;
    }

    @Override
    public void clear() {
        this.reset();
        Arrays.fill(this.mChain, null);
        this.mChainLength = 0;
    }

    @Override
    public void reset() {
        this.setInitialState();
        this.mPayLoad = 0L;
        this.mTotalSpilledBytes = 0L;
        this.mTotalElementsCount = 0L;
        this.mTotalSpilledElementsCount = 0L;
    }

    @Override
    public int size() {
        return this.mChainLength;
    }

    public void dispose() {
        for (int aIdx = 0; aIdx < this.mChainLength; ++aIdx) {
            this.releaseBlock(this.get(aIdx));
        }
        Arrays.fill(this.mChain, null);
        this.mChainLength = 0;
        SpillingUtil.deleteFile(this.getSpilledFile());
        this.setSpilledFile(null);
        this.reset();
    }

    @Override
    public void migrate(MemoryBlockChain theSourceMemoryBlockChain) {
        for (int aIdx = 0; aIdx < theSourceMemoryBlockChain.size(); ++aIdx) {
            this.add(theSourceMemoryBlockChain.get(aIdx));
        }
        this.reset();
        theSourceMemoryBlockChain.clear();
    }

    @Override
    public void trimFront(int theBlockCount) {
        for (int aBlockIndex = 0; aBlockIndex < theBlockCount; ++aBlockIndex) {
            this.releaseBlock(this.removeInternal(0));
        }
        this.setCurrentBlock(0);
    }

    @Override
    public void resetMemoryAfterSpill(boolean trimBlocks) {
        this.setCurrentBlock(0);
        this.setActualBlocksCount(0);
        this.setCurrentBlockOffset(0);
        this.setMemoryElementsCount(0L);
        if (trimBlocks && this.size() > this.mMemoryContext.minBlocksAfterSpill()) {
            int blockCount = Math.min(this.size() / 2, this.size() - this.mMemoryContext.minBlocksAfterSpill());
            while (blockCount-- > 0) {
                this.chop();
            }
        }
    }

    @Override
    public void setMemoryBlock(int theDstIndex, MemoryBlock theMemoryBlock) {
        this.mChain[theDstIndex] = theMemoryBlock;
    }

    private void releaseBlock(MemoryBlock theMemoryBlock) {
        try {
            MemoryBlockPool memoryBlockPool = this.mMemoryContext.getMemoryBlockPool();
            memoryBlockPool.releaseMemoryBlock(theMemoryBlock);
        }
        finally {
            this.mOperationTracker.onMemoryReleased(this.mTotalBlockSize);
        }
    }

    private void setInitialState() {
        this.mOffset = 0;
        this.mActualBlocksCount = 0;
        this.mMemoryElementsCount = 0L;
        this.setCurrentBlock(0);
    }
}

