/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.memoryblock;

import com.complexible.common.unsafe.UnsafeUtil;
import com.complexible.memory.accessor.ByteMemoryAccessor;
import com.complexible.memory.accessor.impl.ByteOrderUtil;
import com.complexible.memory.accessor.impl.SystemMemoryAccessor;
import com.complexible.memory.accessor.impl.byteaccessors.ByteArrayAccessor;
import com.complexible.memory.util.Utilities;
import java.util.Arrays;

public final class ByteArrayMemoryAccessor
implements ByteMemoryAccessor {
    private byte[] memory;

    public ByteArrayMemoryAccessor(byte[] memory) {
        this.memory = memory;
    }

    @Override
    public byte[] array() {
        return this.memory;
    }

    @Override
    public boolean getBoolean(long theAddress) {
        return this.memory[(int)theAddress] > 0;
    }

    @Override
    public void putBoolean(long theAddress, boolean theValue) {
        this.memory[(int)theAddress] = theValue ? (byte)1 : 0;
    }

    @Override
    public byte getByte(long theAddress) {
        return this.memory[(int)theAddress];
    }

    @Override
    public void putByte(long theAddress, byte theValue) {
        this.memory[(int)theAddress] = theValue;
    }

    @Override
    public char getChar(long theAddress) {
        return ByteOrderUtil.readChar(ByteArrayAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.memory, theAddress, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
    }

    @Override
    public void putChar(long theAddress, char theValue) {
        ByteOrderUtil.writeChar(ByteArrayAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.memory, theAddress, theValue, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
    }

    @Override
    public short getShort(long theAddress) {
        return ByteOrderUtil.readShort(ByteArrayAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.memory, theAddress, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
    }

    @Override
    public void putShort(long theAddress, short theValue) {
        ByteOrderUtil.writeShort(ByteArrayAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.memory, theAddress, theValue, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
    }

    @Override
    public int getInt(long theAddress) {
        return ByteOrderUtil.readInt(ByteArrayAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.memory, theAddress, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
    }

    @Override
    public void putInt(long theAddress, int theValue) {
        ByteOrderUtil.writeInt(ByteArrayAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.memory, theAddress, theValue, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
    }

    @Override
    public float getFloat(long theAddress) {
        return ByteOrderUtil.readFloat(ByteArrayAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.memory, theAddress, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
    }

    @Override
    public void putFloat(long theAddress, float theValue) {
        ByteOrderUtil.writeFloat(ByteArrayAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.memory, theAddress, theValue, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
    }

    @Override
    public long getLong(long theAddress) {
        return ByteOrderUtil.readLong(ByteArrayAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.memory, theAddress, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
    }

    @Override
    public void putLong(long theAddress, long theValue) {
        ByteOrderUtil.writeLong(ByteArrayAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.memory, theAddress, theValue, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
    }

    @Override
    public double getDouble(long theAddress) {
        return ByteOrderUtil.readDouble(ByteArrayAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.memory, theAddress, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
    }

    @Override
    public void putDouble(long theAddress, double theValue) {
        ByteOrderUtil.writeDouble(ByteArrayAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.memory, theAddress, theValue, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
    }

    @Override
    public void copyMemory(long theSrcAddress, long theDstAddress, long lengthBytes) {
        System.arraycopy(this.memory, (int)theSrcAddress, this.memory, (int)theDstAddress, (int)lengthBytes);
    }

    @Override
    public void copyFromByteArray(byte[] theSourceArray, int theSrcOffset, long theDstAddress, int theLength) {
        System.arraycopy(theSourceArray, theSrcOffset, this.memory, (int)theDstAddress, theLength);
    }

    @Override
    public void copyFromLongArray(long[] theSourceArray, int theSrcOffset, long theDstAddress, int theLength) {
        if (UnsafeUtil.UNSAFE_AVAILABLE) {
            SystemMemoryAccessor.NATIVE_MEMORY.copyMemory(theSourceArray, SystemMemoryAccessor.ARRAY_LONG_BASE_OFFSET + theSrcOffset, this.memory, SystemMemoryAccessor.ARRAY_BYTE_BASE_OFFSET + (int)theDstAddress, theLength);
            return;
        }
        Utilities.readFromResource(ByteArrayAccessor.LONG_ARRAY_BYTE_ACCESSOR, theSourceArray, theSrcOffset, this.memory, (int)theDstAddress, theLength);
    }

    @Override
    public void copyToByteArray(long theSrcAddress, byte[] theDstArray, int theDstOffset, int theLength) {
        System.arraycopy(this.memory, (int)theSrcAddress, theDstArray, theDstOffset, theLength);
    }

    @Override
    public void copyToLongArray(long[] theDstArray, long theSrcAddress, long theDstOffset, long theLength) {
        if (UnsafeUtil.UNSAFE_AVAILABLE) {
            SystemMemoryAccessor.NATIVE_MEMORY.copyMemory(this.memory, SystemMemoryAccessor.ARRAY_BYTE_BASE_OFFSET + (int)theSrcAddress, theDstArray, (long)SystemMemoryAccessor.ARRAY_LONG_BASE_OFFSET + theDstOffset, theLength);
            return;
        }
        Utilities.readFromResource(ByteArrayAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.memory, theSrcAddress, theDstArray, theDstOffset, theLength, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
    }

    @Override
    public void copyToCharArray(char[] theDstArray, long theSrcAddress, long theDstOffset, long theLength) {
        if (UnsafeUtil.UNSAFE_AVAILABLE) {
            SystemMemoryAccessor.NATIVE_MEMORY.copyMemory(this.memory, SystemMemoryAccessor.ARRAY_BYTE_BASE_OFFSET + (int)theSrcAddress, theDstArray, (long)SystemMemoryAccessor.ARRAY_CHAR_BASE_OFFSET + theDstOffset, theLength);
            return;
        }
        Utilities.readFromResource(ByteArrayAccessor.BYTE_ARRAY_BYTE_ACCESSOR, this.memory, theSrcAddress, theDstArray, theDstOffset, theLength, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
    }

    @Override
    public void copyToNativeMemory(long theSrcAddress, long theDstAddress, long theLengthBytes) {
        if (!UnsafeUtil.UNSAFE_AVAILABLE) {
            throw new UnsupportedOperationException("Unsupported");
        }
        SystemMemoryAccessor.NATIVE_MEMORY.copyFromByteArray(this.memory, (int)theSrcAddress, theDstAddress, (int)theLengthBytes);
    }

    @Override
    public void setMemory(long theAddress, long theLengthBytes, byte theValue) {
        Arrays.fill(this.memory, (int)theAddress, (int)(theAddress + theLengthBytes), theValue);
    }

    public void setMemory(byte[] theMemory) {
        this.memory = theMemory;
    }

    @Override
    public void dispose() {
        this.memory = null;
    }
}

