/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.file.impl;

import com.complexible.common.base.Disposables;
import com.complexible.memory.file.impl.AbstractFileReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public final class DefaultFileReader
extends AbstractFileReader<FileInputStream> {
    public DefaultFileReader(int theBufSize) {
        super(theBufSize);
    }

    @Override
    protected void openInput(FileInputStream theInput) {
        this.mInput = theInput;
        ((FileInputStream)this.mInput).getChannel();
        Disposables.markCreated((Object)this);
    }

    @Override
    protected void openInput(File theInput) throws FileNotFoundException {
        this.openInput(new FileInputStream(theInput));
    }

    @Override
    protected void closeInput() throws IOException {
        ((FileInputStream)this.mInput).close();
        Disposables.markReleased((Object)this);
    }

    @Override
    protected long position() throws IOException {
        return ((FileInputStream)this.mInput).getChannel().position();
    }

    @Override
    protected void position(long thePosition) throws IOException {
        this.mFileOffset = thePosition;
        ((FileInputStream)this.mInput).getChannel().position(thePosition);
    }

    @Override
    protected int read(int theFreeInBuffer) throws IOException {
        return ((FileInputStream)this.mInput).read(this.buffer(), this.mReadLimit, theFreeInBuffer);
    }

    public long length() throws IOException {
        return ((FileInputStream)this.mInput).getChannel().size();
    }

    @Override
    public void close() {
        if (this.mInput == null) {
            this.resetBufferCounters();
            return;
        }
        if (((FileInputStream)this.mInput).getChannel().isOpen()) {
            super.close();
        }
        this.mFileOffset = 0L;
        this.resetBufferCounters();
        this.mInput = null;
    }

    @Override
    public boolean isActive() {
        return this.mInput != null;
    }
}

