/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.file.impl;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.Memory;
import com.complexible.common.io.ByteReader;
import com.complexible.common.unsafe.UnsafeUtil;
import com.complexible.memory.accessor.ByteMemoryAccessor;
import com.complexible.memory.accessor.MemoryAccessor;
import com.complexible.memory.file.FileWriter;
import com.complexible.memory.memoryblock.ByteArrayMemoryAccessor;
import com.complexible.memory.memoryblock.UnsafeByteArrayMemoryAccessor;
import com.complexible.memory.util.Utilities;
import java.io.IOException;

public abstract class AbstractFileWriter<S>
implements FileWriter<S> {
    protected S output;
    protected int position;
    private long mLength;
    private final long mMaxFileLength;
    private final int spillBufferSize;
    private long mFileOffset;
    private long mSyncBytes = 0L;
    private final long mSyncChunkSize;
    private ByteMemoryAccessor mBufferMemoryAccessor;

    AbstractFileWriter(int bufferSize, long theMaxFileLength, long theSyncChunkSize) {
        assert (bufferSize >= 8);
        assert (theSyncChunkSize >= 0x100000L);
        assert (theSyncChunkSize >= (long)bufferSize);
        this.spillBufferSize = bufferSize;
        this.mMaxFileLength = theMaxFileLength;
        this.mSyncChunkSize = theSyncChunkSize;
    }

    @Override
    public void setOutput(S theOutput) {
        assert (this.position == 0) : "Attempt to reset to a new output stream while data still in buffer";
        this.output = theOutput;
        this.mFileOffset = 0L;
        this.mSyncBytes = 0L;
        this.mLength = this.outPutLength(theOutput);
    }

    protected abstract long outPutLength(S var1);

    @Override
    public void writeByteReader(ByteReader theByteReader, long length) {
        assert (theByteReader != null) : "writeMemoryInput() called with null theTapeElementInput";
        try {
            int transferredCount;
            for (long remainingToTransfer = length; remainingToTransfer > 0L; remainingToTransfer -= (long)transferredCount) {
                transferredCount = (int)Math.min(remainingToTransfer, (long)this.spillBufferSize);
                this.ensureRoomInBuffer(transferredCount);
                theByteReader.read(this.buffer(), this.position, transferredCount);
                this.position += transferredCount;
            }
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public void writeByteReader(ByteReader theByteReader) {
        assert (theByteReader != null) : "writeByteReader() called with null theByteReader";
        try {
            this.writeByteReader(theByteReader, theByteReader.length());
        }
        catch (IOException theE) {
            throw Utilities.rethrow(theE);
        }
    }

    @Override
    public void writeBlob(MemoryAccessor theMemoryBlock, int theOffset, int theLength) {
        int transferredCount;
        assert (theMemoryBlock != null) : "writeBlob() called with null memory block";
        int readOffset = theOffset;
        for (long remainingToTransfer = (long)theLength; remainingToTransfer > 0L; remainingToTransfer -= (long)transferredCount) {
            transferredCount = (int)Math.min(remainingToTransfer, (long)this.spillBufferSize);
            this.ensureRoomInBuffer(transferredCount);
            theMemoryBlock.copyToByteArray(readOffset, this.buffer(), this.position, transferredCount);
            readOffset += transferredCount;
            this.position += transferredCount;
        }
    }

    public void write(byte[] theData, int theOffset, int theLength) throws IOException {
        int transferredCount;
        assert (theData != null) : "writeBlob() called with null memory block";
        int readOffset = theOffset;
        for (long remainingToTransfer = (long)theLength; remainingToTransfer > 0L; remainingToTransfer -= (long)transferredCount) {
            transferredCount = (int)Math.min(remainingToTransfer, (long)this.spillBufferSize);
            this.ensureRoomInBuffer(transferredCount);
            System.arraycopy(theData, readOffset, this.buffer(), this.position, transferredCount);
            readOffset += transferredCount;
            this.position += transferredCount;
        }
    }

    public void writeLong(long value) {
        this.ensureRoomInBuffer(8L);
        this.mBufferMemoryAccessor.putLong(this.position, value);
        this.position += 8;
    }

    public void writeInt(int value) {
        this.ensureRoomInBuffer(4L);
        this.mBufferMemoryAccessor.putInt(this.position, value);
        this.position += 4;
    }

    public void writeByte(byte value) {
        this.ensureRoomInBuffer(1L);
        this.mBufferMemoryAccessor.putByte(this.position, value);
        ++this.position;
    }

    public void writeDouble(double theValue) {
        this.ensureRoomInBuffer(8L);
        this.mBufferMemoryAccessor.putDouble(this.position, theValue);
        this.position += 8;
    }

    public void writeFloat(float theValue) {
        this.ensureRoomInBuffer(4L);
        this.mBufferMemoryAccessor.putFloat(this.position, theValue);
        this.position += 4;
    }

    public void writeShort(short theValue) {
        this.ensureRoomInBuffer(2L);
        this.mBufferMemoryAccessor.putShort(this.position, theValue);
        this.position += 2;
    }

    public void writeChar(char theValue) {
        this.ensureRoomInBuffer(2L);
        this.mBufferMemoryAccessor.putChar(this.position, theValue);
        this.position += 2;
    }

    public void writeBuffer(long[] theData, int theOffset, int theLength) {
        int transferredCount;
        assert (theData != null) : "writeBlob() called with null memory block";
        int readOffset = theOffset;
        for (long remainingToTransfer = (long)theLength; remainingToTransfer > 0L; remainingToTransfer -= (long)transferredCount) {
            transferredCount = (int)Math.min(remainingToTransfer, (long)this.spillBufferSize);
            this.ensureRoomInBuffer(transferredCount);
            this.mBufferMemoryAccessor.copyFromLongArray(theData, readOffset, this.position, transferredCount);
            readOffset += transferredCount;
            this.position += transferredCount;
        }
    }

    public long length() {
        return this.mLength;
    }

    public long getPosition() {
        return this.mFileOffset + (long)this.position;
    }

    public void setPosition(long thePosition) throws IOException {
        this.flush();
        this.moveToPosition(thePosition);
        this.mFileOffset = thePosition;
    }

    public void write(byte[] theData) throws IOException {
        this.write(theData, 0, theData.length);
    }

    public void writeVInt(int theValue) {
        this.writeInt(theValue);
    }

    public void writeVLong(long theValue) {
        this.writeLong(theValue);
    }

    public void writeString(String theValue) {
        throw new UnsupportedOperationException("");
    }

    @Override
    public void flush() throws IOException {
        long aNewSize = this.mFileOffset + (long)this.position;
        if (this.position > 0) {
            if (aNewSize > this.mMaxFileLength) {
                if (this.mMaxFileLength == 0L) {
                    throw new IOException("Spilling to disk is disabled. Try optimizing the query or alternatively increase memory limits.");
                }
                throw new IOException("Maximum file length exceeded: " + Memory.readable((long)this.mMaxFileLength));
            }
            this.writeOutput();
            this.mFileOffset += (long)this.position;
            this.position = 0;
        }
        this.flushOutput();
        if (aNewSize >= this.mSyncChunkSize + this.mSyncBytes) {
            this.syncOutput();
            this.mSyncBytes += this.mSyncChunkSize;
        }
    }

    @Override
    public void close() {
        if (this.output != null) {
            AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this::flush, this::closeOutput});
            this.mSyncBytes = 0L;
            this.position = 0;
            this.mFileOffset = 0L;
        }
    }

    public void dispose() {
        this.mSyncBytes = 0L;
        this.position = 0;
        this.mFileOffset = 0L;
        if (this.output != null) {
            AutoCloser.close((AutoCloseable[])new AutoCloseable[]{this::closeOutput});
        }
    }

    public boolean isOverflowed() {
        return false;
    }

    protected abstract void flushOutput() throws IOException;

    protected abstract void writeOutput() throws IOException;

    protected abstract void syncOutput() throws IOException;

    protected abstract void closeOutput() throws IOException;

    protected abstract void moveToPosition(long var1);

    protected final byte[] buffer() {
        return this.mBufferMemoryAccessor.array();
    }

    private void ensureRoomInBuffer(long requiredByteCount) {
        if (this.mBufferMemoryAccessor == null) {
            byte[] buffer = new byte[this.spillBufferSize];
            ByteMemoryAccessor byteMemoryAccessor = this.mBufferMemoryAccessor = UnsafeUtil.UNSAFE_AVAILABLE ? new UnsafeByteArrayMemoryAccessor(buffer) : new ByteArrayMemoryAccessor(buffer);
        }
        if ((long)this.position + requiredByteCount <= (long)this.spillBufferSize) {
            return;
        }
        try {
            this.flush();
        }
        catch (IOException e) {
            throw Utilities.rethrow(e);
        }
    }
}

