/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.accessor.impl.byteaccessors;

import com.complexible.memory.accessor.ByteAccessor;

public final class ByteArrayAccessor
implements ByteAccessor<byte[]> {
    public static final ByteArrayAccessor INSTANCE = new ByteArrayAccessor();

    private ByteArrayAccessor() {
    }

    @Override
    public byte getByte(byte[] theResource, long theOffset) {
        ByteArrayAccessor.validateOffset(theOffset);
        return theResource[(int)theOffset];
    }

    @Override
    public void putByte(byte[] theResource, long theOffset, byte theValue) {
        ByteArrayAccessor.validateOffset(theOffset);
        theResource[(int)theOffset] = theValue;
    }

    private static void validateOffset(long arg) {
        assert (arg >= 0L && arg <= Integer.MAX_VALUE) : "argument outside of int range: " + arg;
    }
}

