/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.accessor.impl;

import com.complexible.common.unsafe.UnsafeUtil;
import com.complexible.memory.accessor.ByteAccessor;
import com.complexible.memory.accessor.impl.ByteOrderUtil;
import com.complexible.memory.accessor.impl.SystemMemoryAccessor;

final class SystemAlignedNativeMemoryAccessor
implements SystemMemoryAccessor {
    public static final SystemAlignedNativeMemoryAccessor INSTANCE = UnsafeUtil.UNSAFE_AVAILABLE ? new SystemAlignedNativeMemoryAccessor() : null;

    private SystemAlignedNativeMemoryAccessor() {
        if (!UnsafeUtil.UNSAFE_AVAILABLE) {
            throw new IllegalStateException("UNSAFE is unavailable");
        }
    }

    @Override
    public boolean getBoolean(long theAddress) {
        return UnsafeUtil.UNSAFE.getBoolean(null, theAddress);
    }

    @Override
    public void putBoolean(long theAddress, boolean theValue) {
        UnsafeUtil.UNSAFE.putBoolean(null, theAddress, theValue);
    }

    @Override
    public byte getByte(long theAddress) {
        return UnsafeUtil.UNSAFE.getByte(theAddress);
    }

    @Override
    public void putByte(long theAddress, byte theValue) {
        UnsafeUtil.UNSAFE.putByte(theAddress, theValue);
    }

    @Override
    public char getChar(long theAddress) {
        return this.is2BytesAligned(theAddress) ? UnsafeUtil.UNSAFE.getChar(theAddress) : ByteOrderUtil.readChar(ByteAccessor.OBJECT_BYTE_ACCESSOR, null, theAddress, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
    }

    @Override
    public void putChar(long theAddress, char theValue) {
        if (this.is2BytesAligned(theAddress)) {
            UnsafeUtil.UNSAFE.putChar(theAddress, theValue);
        } else {
            ByteOrderUtil.writeChar(ByteAccessor.OBJECT_BYTE_ACCESSOR, null, theAddress, theValue, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
        }
    }

    @Override
    public short getShort(long theAddress) {
        return this.is2BytesAligned(theAddress) ? UnsafeUtil.UNSAFE.getShort(theAddress) : ByteOrderUtil.readShort(ByteAccessor.OBJECT_BYTE_ACCESSOR, null, theAddress, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
    }

    @Override
    public void putShort(long theAddress, short theValue) {
        if (this.is2BytesAligned(theAddress)) {
            UnsafeUtil.UNSAFE.putShort(theAddress, theValue);
        } else {
            ByteOrderUtil.writeShort(ByteAccessor.OBJECT_BYTE_ACCESSOR, null, theAddress, theValue, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
        }
    }

    @Override
    public int getInt(long theAddress) {
        return this.is4BytesAligned(theAddress) ? UnsafeUtil.UNSAFE.getInt(theAddress) : ByteOrderUtil.readInt(ByteAccessor.OBJECT_BYTE_ACCESSOR, null, theAddress, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
    }

    @Override
    public void putInt(long theAddress, int theValue) {
        if (this.is4BytesAligned(theAddress)) {
            UnsafeUtil.UNSAFE.putInt(theAddress, theValue);
        } else {
            ByteOrderUtil.writeInt(ByteAccessor.OBJECT_BYTE_ACCESSOR, null, theAddress, theValue, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
        }
    }

    @Override
    public float getFloat(long theAddress) {
        return this.is4BytesAligned(theAddress) ? UnsafeUtil.UNSAFE.getFloat(theAddress) : ByteOrderUtil.readFloat(ByteAccessor.OBJECT_BYTE_ACCESSOR, null, theAddress, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
    }

    @Override
    public void putFloat(long theAddress, float theValue) {
        if (this.is4BytesAligned(theAddress)) {
            UnsafeUtil.UNSAFE.putFloat(theAddress, theValue);
        } else {
            ByteOrderUtil.writeFloat(ByteAccessor.OBJECT_BYTE_ACCESSOR, null, theAddress, theValue, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
        }
    }

    @Override
    public long getLong(long theAddress) {
        return this.is8BytesAligned(theAddress) ? UnsafeUtil.UNSAFE.getLong(theAddress) : ByteOrderUtil.readLong(ByteAccessor.OBJECT_BYTE_ACCESSOR, null, theAddress, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
    }

    @Override
    public void putLong(long theAddress, long theValue) {
        if (this.is8BytesAligned(theAddress)) {
            UnsafeUtil.UNSAFE.putLong(theAddress, theValue);
        } else {
            ByteOrderUtil.writeLong(ByteAccessor.OBJECT_BYTE_ACCESSOR, null, theAddress, theValue, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
        }
    }

    @Override
    public double getDouble(long theAddress) {
        return this.is8BytesAligned(theAddress) ? UnsafeUtil.UNSAFE.getDouble(theAddress) : ByteOrderUtil.readDouble(ByteAccessor.OBJECT_BYTE_ACCESSOR, null, theAddress, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
    }

    @Override
    public void putDouble(long theAddress, double theValue) {
        if (this.is8BytesAligned(theAddress)) {
            UnsafeUtil.UNSAFE.putDouble(theAddress, theValue);
        } else {
            ByteOrderUtil.writeDouble(ByteAccessor.OBJECT_BYTE_ACCESSOR, null, theAddress, theValue, ByteOrderUtil.IS_SYSTEM_BIG_ENDIAN);
        }
    }

    @Override
    public void copyMemory(long theSrcAddress, long theDstAddress, long theLengthBytes) {
        UnsafeUtil.UNSAFE.copyMemory(theSrcAddress, theDstAddress, theLengthBytes);
    }

    @Override
    public void copyFromByteArray(byte[] theSourceArray, int theSrcOffset, long theDstAddress, int theLength) {
        this.copyMemory(theSourceArray, ARRAY_BYTE_BASE_OFFSET + ARRAY_BYTE_INDEX_SCALE * theSrcOffset, null, theDstAddress, theLength);
    }

    @Override
    public void copyFromLongArray(long[] theSourceArray, int theSrcOffset, long theDstAddress, int theLength) {
        this.copyMemory(theSourceArray, ARRAY_LONG_BASE_OFFSET + theSrcOffset, null, theDstAddress, theLength);
    }

    @Override
    public void copyToByteArray(long theSrcAddress, byte[] theDstArray, int theDstOffset, int theLength) {
        this.copyMemory(null, theSrcAddress, theDstArray, ARRAY_BYTE_BASE_OFFSET + ARRAY_BYTE_INDEX_SCALE * theDstOffset, theLength);
    }

    @Override
    public void copyToLongArray(long[] theDstArray, long theSrcAddress, long theDstOffset, long theLength) {
        this.copyMemory(null, theSrcAddress, theDstArray, (long)ARRAY_LONG_BASE_OFFSET + theDstOffset, theLength);
    }

    @Override
    public void copyToCharArray(char[] theDstArray, long theSrcAddress, long theDstOffset, long theLength) {
        this.copyMemory(null, theSrcAddress, theDstArray, (long)ARRAY_CHAR_BASE_OFFSET + theDstOffset, theLength);
    }

    @Override
    public void setMemory(long theAddress, long theLengthBytes, byte theValue) {
        UnsafeUtil.UNSAFE.setMemory(theAddress, theLengthBytes, theValue);
    }

    @Override
    public int arrayBaseOffset(Class<?> arrayClass) {
        return UnsafeUtil.UNSAFE.arrayBaseOffset(arrayClass);
    }

    @Override
    public int arrayIndexScale(Class<?> arrayClass) {
        return UnsafeUtil.UNSAFE.arrayIndexScale(arrayClass);
    }

    @Override
    public void copyMemory(Object srcObj, long srcOffset, Object destObj, long destOffset, long lengthBytes) {
        UnsafeUtil.UNSAFE.copyMemory(srcObj, srcOffset, destObj, destOffset, lengthBytes);
    }

    @Override
    public byte getByte(Object theResource, long theOffset) {
        return UnsafeUtil.UNSAFE.getByte(theResource, theOffset);
    }

    @Override
    public void putByte(Object theResource, long theOffset, byte theValue) {
        UnsafeUtil.UNSAFE.putByte(theResource, theOffset, theValue);
    }

    private boolean is2BytesAligned(long theAddress) {
        return (theAddress & 1L) == 0L;
    }

    private boolean is4BytesAligned(long theAddress) {
        return (theAddress & 3L) == 0L;
    }

    private boolean is8BytesAligned(long theAddress) {
        return (theAddress & 7L) == 0L;
    }
}

