/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.accessor.impl;

import com.complexible.memory.accessor.ByteAccessor;
import java.nio.ByteOrder;

public final class ByteOrderUtil {
    public static final boolean IS_SYSTEM_BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;

    private ByteOrderUtil() {
    }

    public static <R> short readShort(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, boolean useBigEndian) {
        return useBigEndian ? ByteOrderUtil.readShortB(theByteAccessor, theByteSource, theOffset) : ByteOrderUtil.readShortL(theByteAccessor, theByteSource, theOffset);
    }

    public static <R> short readShortB(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset) {
        int byte1 = theByteAccessor.getByte(theByteSource, theOffset) & 0xFF;
        int byte0 = theByteAccessor.getByte(theByteSource, theOffset + 1L) & 0xFF;
        return (short)(byte1 << 8 | byte0);
    }

    public static <R> short readShortL(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset) {
        int byte1 = theByteAccessor.getByte(theByteSource, theOffset) & 0xFF;
        int byte0 = theByteAccessor.getByte(theByteSource, theOffset + 1L) & 0xFF;
        return (short)(byte0 << 8 | byte1);
    }

    public static <R> void writeShort(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, short v, boolean useBigEndian) {
        if (useBigEndian) {
            ByteOrderUtil.writeShortB(theByteAccessor, theByteSource, theOffset, v);
        } else {
            ByteOrderUtil.writeShortL(theByteAccessor, theByteSource, theOffset, v);
        }
    }

    public static <R> void writeShortB(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, short v) {
        theByteAccessor.putByte(theByteSource, theOffset, (byte)(v >>> 8 & 0xFF));
        theByteAccessor.putByte(theByteSource, theOffset + 1L, (byte)(v & 0xFF));
    }

    public static <R> void writeShortL(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, short v) {
        theByteAccessor.putByte(theByteSource, theOffset, (byte)(v & 0xFF));
        theByteAccessor.putByte(theByteSource, theOffset + 1L, (byte)(v >>> 8 & 0xFF));
    }

    public static <R> int readInt(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, boolean useBigEndian) {
        return useBigEndian ? ByteOrderUtil.readIntB(theByteAccessor, theByteSource, theOffset) : ByteOrderUtil.readIntL(theByteAccessor, theByteSource, theOffset);
    }

    public static <R> int readIntB(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset) {
        int byte3 = (theByteAccessor.getByte(theByteSource, theOffset) & 0xFF) << 24;
        int byte2 = (theByteAccessor.getByte(theByteSource, theOffset + 1L) & 0xFF) << 16;
        int byte1 = (theByteAccessor.getByte(theByteSource, theOffset + 2L) & 0xFF) << 8;
        int byte0 = theByteAccessor.getByte(theByteSource, theOffset + 3L) & 0xFF;
        return byte3 | byte2 | byte1 | byte0;
    }

    public static <R> int readIntL(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset) {
        int byte3 = theByteAccessor.getByte(theByteSource, theOffset) & 0xFF;
        int byte2 = (theByteAccessor.getByte(theByteSource, theOffset + 1L) & 0xFF) << 8;
        int byte1 = (theByteAccessor.getByte(theByteSource, theOffset + 2L) & 0xFF) << 16;
        int byte0 = (theByteAccessor.getByte(theByteSource, theOffset + 3L) & 0xFF) << 24;
        return byte3 | byte2 | byte1 | byte0;
    }

    public static <R> void writeInt(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, int v, boolean useBigEndian) {
        if (useBigEndian) {
            ByteOrderUtil.writeIntB(theByteAccessor, theByteSource, theOffset, v);
        } else {
            ByteOrderUtil.writeIntL(theByteAccessor, theByteSource, theOffset, v);
        }
    }

    public static <R> void writeIntB(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, int v) {
        theByteAccessor.putByte(theByteSource, theOffset, (byte)(v >>> 24 & 0xFF));
        theByteAccessor.putByte(theByteSource, theOffset + 1L, (byte)(v >>> 16 & 0xFF));
        theByteAccessor.putByte(theByteSource, theOffset + 2L, (byte)(v >>> 8 & 0xFF));
        theByteAccessor.putByte(theByteSource, theOffset + 3L, (byte)(v & 0xFF));
    }

    public static <R> void writeIntL(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, int v) {
        theByteAccessor.putByte(theByteSource, theOffset, (byte)(v & 0xFF));
        theByteAccessor.putByte(theByteSource, theOffset + 1L, (byte)(v >>> 8 & 0xFF));
        theByteAccessor.putByte(theByteSource, theOffset + 2L, (byte)(v >>> 16 & 0xFF));
        theByteAccessor.putByte(theByteSource, theOffset + 3L, (byte)(v >>> 24 & 0xFF));
    }

    public static <R> float readFloat(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, boolean useBigEndian) {
        return useBigEndian ? ByteOrderUtil.readFloatB(theByteAccessor, theByteSource, theOffset) : ByteOrderUtil.readFloatL(theByteAccessor, theByteSource, theOffset);
    }

    public static <R> float readFloatB(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset) {
        return Float.intBitsToFloat(ByteOrderUtil.readIntB(theByteAccessor, theByteSource, theOffset));
    }

    public static <R> float readFloatL(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset) {
        return Float.intBitsToFloat(ByteOrderUtil.readIntL(theByteAccessor, theByteSource, theOffset));
    }

    public static <R> void writeFloat(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, float v, boolean useBigEndian) {
        if (useBigEndian) {
            ByteOrderUtil.writeFloatB(theByteAccessor, theByteSource, theOffset, v);
        } else {
            ByteOrderUtil.writeFloatL(theByteAccessor, theByteSource, theOffset, v);
        }
    }

    public static <R> void writeFloatB(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, float v) {
        ByteOrderUtil.writeIntB(theByteAccessor, theByteSource, theOffset, Float.floatToRawIntBits(v));
    }

    public static <R> void writeFloatL(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, float v) {
        ByteOrderUtil.writeIntL(theByteAccessor, theByteSource, theOffset, Float.floatToRawIntBits(v));
    }

    public static <R> long readLong(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, boolean useBigEndian) {
        return useBigEndian ? ByteOrderUtil.readLongB(theByteAccessor, theByteSource, theOffset) : ByteOrderUtil.readLongL(theByteAccessor, theByteSource, theOffset);
    }

    public static <R> long readLongB(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset) {
        long byte7 = (long)theByteAccessor.getByte(theByteSource, theOffset) << 56;
        long byte6 = (long)(theByteAccessor.getByte(theByteSource, theOffset + 1L) & 0xFF) << 48;
        long byte5 = (long)(theByteAccessor.getByte(theByteSource, theOffset + 2L) & 0xFF) << 40;
        long byte4 = (long)(theByteAccessor.getByte(theByteSource, theOffset + 3L) & 0xFF) << 32;
        long byte3 = (long)(theByteAccessor.getByte(theByteSource, theOffset + 4L) & 0xFF) << 24;
        long byte2 = (long)(theByteAccessor.getByte(theByteSource, theOffset + 5L) & 0xFF) << 16;
        long byte1 = (long)(theByteAccessor.getByte(theByteSource, theOffset + 6L) & 0xFF) << 8;
        long byte0 = theByteAccessor.getByte(theByteSource, theOffset + 7L) & 0xFF;
        return byte7 | byte6 | byte5 | byte4 | byte3 | byte2 | byte1 | byte0;
    }

    public static <R> long readLongL(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset) {
        long byte7 = theByteAccessor.getByte(theByteSource, theOffset) & 0xFF;
        long byte6 = (long)(theByteAccessor.getByte(theByteSource, theOffset + 1L) & 0xFF) << 8;
        long byte5 = (long)(theByteAccessor.getByte(theByteSource, theOffset + 2L) & 0xFF) << 16;
        long byte4 = (long)(theByteAccessor.getByte(theByteSource, theOffset + 3L) & 0xFF) << 24;
        long byte3 = (long)(theByteAccessor.getByte(theByteSource, theOffset + 4L) & 0xFF) << 32;
        long byte2 = (long)(theByteAccessor.getByte(theByteSource, theOffset + 5L) & 0xFF) << 40;
        long byte1 = (long)(theByteAccessor.getByte(theByteSource, theOffset + 6L) & 0xFF) << 48;
        long byte0 = (long)(theByteAccessor.getByte(theByteSource, theOffset + 7L) & 0xFF) << 56;
        return byte7 | byte6 | byte5 | byte4 | byte3 | byte2 | byte1 | byte0;
    }

    public static <R> long readLong(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, int bytesCount, boolean useBigEndian) {
        return useBigEndian ? ByteOrderUtil.readLongB(theByteAccessor, theByteSource, theOffset, bytesCount) : ByteOrderUtil.readLongL(theByteAccessor, theByteSource, theOffset, bytesCount);
    }

    public static <R> long readLongB(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, int bytesCount) {
        long result = 0L;
        for (int i = 0; i < bytesCount; ++i) {
            long byteValue = (long)(theByteAccessor.getByte(theByteSource, theOffset + (long)i) & 0xFF) << 56 - (i << 3);
            result |= byteValue;
        }
        return result;
    }

    public static <R> long readLongL(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, int bytesCount) {
        long result = 0L;
        for (int i = 0; i < bytesCount; ++i) {
            long byteValue = (long)(theByteAccessor.getByte(theByteSource, theOffset + (long)i) & 0xFF) << (i << 3);
            result |= byteValue;
        }
        return result;
    }

    public static <R> void writeLong(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, int theBytesOffset, long theValue, int theBytesCount, boolean useBigEndian) {
        if (useBigEndian) {
            ByteOrderUtil.writeLongB(theByteAccessor, theByteSource, theOffset, theBytesOffset, theValue, theBytesCount);
        } else {
            ByteOrderUtil.writeLongL(theByteAccessor, theByteSource, theOffset, theBytesOffset, theValue, theBytesCount);
        }
    }

    public static <R> void writeLongB(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, int theBytesOffset, long theValue, int theBytesCount) {
        for (int i = 0; i < theBytesCount; ++i) {
            theByteAccessor.putByte(theByteSource, theOffset + (long)i, (byte)(theValue >>> 56 - (theBytesOffset + i << 3)));
        }
    }

    public static <R> void writeLongL(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, int theBytesOffset, long v, int bytesCount) {
        for (int i = 0; i < bytesCount; ++i) {
            theByteAccessor.putByte(theByteSource, theOffset + (long)i, (byte)(v >>> (i + theBytesOffset << 3)));
        }
    }

    public static <R> void writeLong(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, long theValue, boolean theUseBigEndian) {
        if (theUseBigEndian) {
            ByteOrderUtil.writeLongB(theByteAccessor, theByteSource, theOffset, theValue);
        } else {
            ByteOrderUtil.writeLongL(theByteAccessor, theByteSource, theOffset, theValue);
        }
    }

    public static <R> void writeLongB(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, long theValue) {
        theByteAccessor.putByte(theByteSource, theOffset, (byte)(theValue >>> 56));
        theByteAccessor.putByte(theByteSource, theOffset + 1L, (byte)(theValue >>> 48));
        theByteAccessor.putByte(theByteSource, theOffset + 2L, (byte)(theValue >>> 40));
        theByteAccessor.putByte(theByteSource, theOffset + 3L, (byte)(theValue >>> 32));
        theByteAccessor.putByte(theByteSource, theOffset + 4L, (byte)(theValue >>> 24));
        theByteAccessor.putByte(theByteSource, theOffset + 5L, (byte)(theValue >>> 16));
        theByteAccessor.putByte(theByteSource, theOffset + 6L, (byte)(theValue >>> 8));
        theByteAccessor.putByte(theByteSource, theOffset + 7L, (byte)theValue);
    }

    public static <R> void writeLongL(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, long theValue) {
        theByteAccessor.putByte(theByteSource, theOffset, (byte)theValue);
        theByteAccessor.putByte(theByteSource, theOffset + 1L, (byte)(theValue >>> 8));
        theByteAccessor.putByte(theByteSource, theOffset + 2L, (byte)(theValue >>> 16));
        theByteAccessor.putByte(theByteSource, theOffset + 3L, (byte)(theValue >>> 24));
        theByteAccessor.putByte(theByteSource, theOffset + 4L, (byte)(theValue >>> 32));
        theByteAccessor.putByte(theByteSource, theOffset + 5L, (byte)(theValue >>> 40));
        theByteAccessor.putByte(theByteSource, theOffset + 6L, (byte)(theValue >>> 48));
        theByteAccessor.putByte(theByteSource, theOffset + 7L, (byte)(theValue >>> 56));
    }

    public static <R> double readDouble(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, boolean theUseBigEndian) {
        return theUseBigEndian ? ByteOrderUtil.readDoubleB(theByteAccessor, theByteSource, theOffset) : ByteOrderUtil.readDoubleL(theByteAccessor, theByteSource, theOffset);
    }

    public static <R> double readDoubleB(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset) {
        return Double.longBitsToDouble(ByteOrderUtil.readLongB(theByteAccessor, theByteSource, theOffset));
    }

    public static <R> double readDoubleL(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset) {
        return Double.longBitsToDouble(ByteOrderUtil.readLongL(theByteAccessor, theByteSource, theOffset));
    }

    public static <R> void writeDouble(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, double v, boolean theUseBigEndian) {
        if (theUseBigEndian) {
            ByteOrderUtil.writeDoubleB(theByteAccessor, theByteSource, theOffset, v);
        } else {
            ByteOrderUtil.writeDoubleL(theByteAccessor, theByteSource, theOffset, v);
        }
    }

    public static <R> void writeDoubleB(ByteAccessor<R> memoryAccesstheByteAccessor, R theByteSource, long theOffset, double theValue) {
        ByteOrderUtil.writeLongB(memoryAccesstheByteAccessor, theByteSource, theOffset, Double.doubleToRawLongBits(theValue));
    }

    public static <R> void writeDoubleL(ByteAccessor<R> memoryAccesstheByteAccessor, R theByteSource, long theOffset, double theValue) {
        ByteOrderUtil.writeLongL(memoryAccesstheByteAccessor, theByteSource, theOffset, Double.doubleToRawLongBits(theValue));
    }

    public static <R> char readChar(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, boolean theUseBigEndian) {
        return theUseBigEndian ? ByteOrderUtil.readCharB(theByteAccessor, theByteSource, theOffset) : ByteOrderUtil.readCharL(theByteAccessor, theByteSource, theOffset);
    }

    public static <R> char readCharB(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset) {
        int byte1 = theByteAccessor.getByte(theByteSource, theOffset) & 0xFF;
        int byte0 = theByteAccessor.getByte(theByteSource, theOffset + 1L) & 0xFF;
        return (char)(byte1 << 8 | byte0);
    }

    public static <R> char readCharL(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset) {
        int byte1 = theByteAccessor.getByte(theByteSource, theOffset) & 0xFF;
        int byte0 = theByteAccessor.getByte(theByteSource, theOffset + 1L) & 0xFF;
        return (char)(byte0 << 8 | byte1);
    }

    public static <R> void writeChar(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, char theValue, boolean theUseBigEndian) {
        if (theUseBigEndian) {
            ByteOrderUtil.writeCharB(theByteAccessor, theByteSource, theOffset, theValue);
        } else {
            ByteOrderUtil.writeCharL(theByteAccessor, theByteSource, theOffset, theValue);
        }
    }

    public static <R> void writeCharB(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, char theValue) {
        theByteAccessor.putByte(theByteSource, theOffset, (byte)(theValue >>> 8 & 0xFF));
        theByteAccessor.putByte(theByteSource, theOffset + 1L, (byte)(theValue & 0xFF));
    }

    public static <R> void writeCharL(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, char theValue) {
        theByteAccessor.putByte(theByteSource, theOffset, (byte)(theValue & 0xFF));
        theByteAccessor.putByte(theByteSource, theOffset + 1L, (byte)(theValue >>> 8 & 0xFF));
    }

    public static <R> char readChar(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, int bytesCount, boolean useBigEndian) {
        return useBigEndian ? ByteOrderUtil.readCharB(theByteAccessor, theByteSource, theOffset, bytesCount) : ByteOrderUtil.readCharL(theByteAccessor, theByteSource, theOffset, bytesCount);
    }

    public static <R> char readCharB(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, int bytesCount) {
        char result = '\u0000';
        for (int i = 0; i < bytesCount; ++i) {
            char byteValue = (char)((char)(theByteAccessor.getByte(theByteSource, theOffset + (long)i) & 0xFF) << 8 - (i << 1));
            result = (char)(result | byteValue);
        }
        return result;
    }

    public static <R> char readCharL(ByteAccessor<R> theByteAccessor, R theByteSource, long theOffset, int bytesCount) {
        char result = '\u0000';
        for (int i = 0; i < bytesCount; ++i) {
            char byteValue = (char)((char)(theByteAccessor.getByte(theByteSource, theOffset + (long)i) & 0xFF) << (i << 1));
            result = (char)(result | byteValue);
        }
        return result;
    }
}

