/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.accessor;

import com.complexible.common.unsafe.UnsafeUtil;
import com.complexible.memory.accessor.ByteAccessor;
import com.complexible.memory.accessor.impl.SystemMemoryAccessor;

public final class UnsafeLongArrayAccessor
implements ByteAccessor<long[]> {
    public static final UnsafeLongArrayAccessor INSTANCE = new UnsafeLongArrayAccessor();

    private UnsafeLongArrayAccessor() {
    }

    @Override
    public byte getByte(long[] theResource, long theOffset) {
        return UnsafeUtil.UNSAFE.getByte(theResource, (long)SystemMemoryAccessor.ARRAY_LONG_BASE_OFFSET + (long)SystemMemoryAccessor.ARRAY_BYTE_INDEX_SCALE * theOffset);
    }

    @Override
    public void putByte(long[] theResource, long theOffset, byte theValue) {
        UnsafeUtil.UNSAFE.putByte(theResource, (long)SystemMemoryAccessor.ARRAY_LONG_BASE_OFFSET + (long)SystemMemoryAccessor.ARRAY_BYTE_INDEX_SCALE * theOffset, theValue);
    }
}

