/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.memory.accessor;

import com.complexible.memory.accessor.ByteAccessor;
import com.complexible.memory.util.Utilities;

public class LongArrayAccessor
implements ByteAccessor<long[]> {
    public static final LongArrayAccessor INSTANCE = new LongArrayAccessor();
    private static final int longMask = 7;

    private LongArrayAccessor() {
    }

    @Override
    public byte getByte(long[] theResource, long theOffset) {
        int aLongIndex = Utilities.divideLongPowerOfTwoAsInt(theOffset, 3);
        int aBytePosition = Utilities.maskLongPowerOfTwoAsInt(theOffset, 7);
        int aBitsPosition = Utilities.multiplyIntPowerOfTwoAsInt(aBytePosition, 3);
        return Utilities.divideLongPowerOfTwoAsByte(theResource[aLongIndex], aBitsPosition);
    }

    @Override
    public void putByte(long[] theResource, long theOffset, byte theValue) {
        int aLongIndex = Utilities.divideLongPowerOfTwoAsInt(theOffset, 3);
        int aBytePosition = Utilities.maskLongPowerOfTwoAsInt(theOffset, 7);
        int aBitsPosition = Utilities.multiplyIntPowerOfTwoAsInt(aBytePosition, 3);
        theResource[aLongIndex] = theResource[aLongIndex] ^ Utilities.multiplyIntPowerOfTwoAsLong(255, aBitsPosition) | Utilities.multiplyBytePowerOfTwoAsLong(theValue, aBitsPosition);
    }
}

