/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.http.io;

import com.complexible.common.base.Numbers;
import com.complexible.stardog.metadata.MetaProperty;
import com.complexible.stardog.metadata.Metadata;
import com.google.common.base.Strings;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Collection;

public final class MetadataJsonSerializer
implements JsonSerializer<Metadata> {
    public JsonElement serialize(Metadata aMeta, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject aJson = new JsonObject();
        for (MetaProperty aProp : aMeta) {
            if (aMeta.get(aProp) instanceof Boolean) {
                aJson.addProperty(aProp.getName(), (Boolean)aMeta.get(aProp));
                continue;
            }
            if (aMeta.get(aProp) instanceof Number) {
                Number aNumProp = (Number)aMeta.get(aProp);
                aJson.addProperty(aProp.getName(), Numbers.isNaN((Number)aNumProp) ? (Number)((Number)aProp.getDefaultValue()) : (Number)aNumProp);
                continue;
            }
            if (aMeta.get(aProp) instanceof Collection) {
                String[] anElemsArr;
                String aCollectionSerialized = aProp.getTextIO().write(aMeta.get(aProp));
                JsonArray aJsonArray = new JsonArray();
                for (String aStr : anElemsArr = aCollectionSerialized.split(String.valueOf('\u0002'))) {
                    if (Strings.isNullOrEmpty((String)aStr)) continue;
                    try {
                        aJsonArray.add(JsonParser.parseString((String)aStr));
                    }
                    catch (JsonParseException jpe) {
                        aJsonArray.add((JsonElement)new JsonPrimitive(aStr));
                    }
                }
                aJson.add(aProp.getName(), (JsonElement)aJsonArray);
                continue;
            }
            aJson.addProperty(aProp.getName(), aProp.getTextIO().write(aMeta.get(aProp)));
        }
        return aJson;
    }
}

