/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.http.io;

import com.complexible.stardog.metadata.MetaProperties;
import com.complexible.stardog.metadata.MetaProperty;
import com.complexible.stardog.metadata.Metadata;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;

public final class MetadataJsonDeserializer
implements JsonDeserializer<Metadata> {
    public Metadata deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Metadata aMetadata = Metadata.create();
        if (json != null && json.isJsonObject()) {
            JsonObject topJSON = json.getAsJsonObject();
            for (Map.Entry aProp : topJSON.entrySet()) {
                JsonElement aPropVal = (JsonElement)aProp.getValue();
                MetaProperty aMetaProp = this.getProperty((String)aProp.getKey());
                if (aMetaProp == null) continue;
                if (aPropVal.isJsonArray()) {
                    ArrayList aStrValues = Lists.newArrayList((Iterable)Iterables.transform((Iterable)aPropVal.getAsJsonArray(), this::getStringValue));
                    aMetadata.set(aMetaProp, aMetaProp.getTextIO().read(Joiner.on((char)'\u0002').join((Iterable)aStrValues)));
                    continue;
                }
                if (aPropVal.isJsonObject() && aPropVal.getAsJsonObject().has("value")) {
                    aMetadata.set(aMetaProp, aMetaProp.getTextIO().read(aPropVal.getAsJsonObject().getAsJsonPrimitive("value").getAsString()));
                    continue;
                }
                aMetadata.set(aMetaProp, aMetaProp.getTextIO().read(this.getStringValue(aPropVal)));
            }
        }
        return aMetadata;
    }

    private MetaProperty getProperty(String theKey) {
        MetaProperty aProp = MetaProperties.get((String)theKey);
        if (aProp == null && theKey.startsWith("dbms.")) {
            aProp = MetaProperties.get((String)theKey.substring(5));
        }
        return aProp;
    }

    private String getStringValue(JsonElement theElem) {
        String aStrVal = theElem.isJsonPrimitive() && theElem.getAsJsonPrimitive().isString() ? theElem.getAsJsonPrimitive().getAsString() : theElem.toString();
        return aStrVal;
    }
}

