/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.protocols.http.admin;

import com.complexible.stardog.DefaultQueryInfo;
import com.complexible.stardog.ExplainableQueryInfo;
import com.complexible.stardog.QueryInfo;
import com.complexible.stardog.protocols.http.admin.JsonOptionsObject;
import java.util.Optional;

public final class QueryInfoOptions
extends JsonOptionsObject {
    private String kernelId;
    private String id;
    private String user;
    private String db;
    private String query;
    private String queryType;
    private String plan;
    private long startTime;
    private long endTime;
    private long preExecutionTime;
    private long timeout;
    private String reasoningSchema;
    private String status;

    public QueryInfoOptions(QueryInfo theInfo) {
        this.setKernelId(theInfo.getKernelID());
        this.setId(theInfo.getID());
        this.setUser(theInfo.getUser());
        this.setDb(theInfo.getDBName());
        this.setQuery(theInfo.getQuery());
        Optional plan = theInfo.getRenderedPlan();
        plan.ifPresent(this::setPlan);
        this.setStartTime(theInfo.getStartTime());
        this.setEndTime(theInfo.getEndTime());
        this.setPreExecutionTime(theInfo.getPreExecutionTime());
        this.setTimeout(theInfo.getTimeout());
        this.setStatus(theInfo.getStatus().name());
        this.setReasoningSchema(theInfo.getReasoningSchema());
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public void setKernelId(String id) {
        this.kernelId = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getDb() {
        return this.db;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void setPreExecutionTime(long preExecutionTime) {
        this.preExecutionTime = preExecutionTime;
    }

    public String getQueryType() {
        return this.queryType;
    }

    public void setQueryType(String theQueryType) {
        this.queryType = theQueryType;
    }

    public String getPlan() {
        return this.plan;
    }

    public void setPlan(String thePlan) {
        this.plan = thePlan;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public String getReasoningSchema() {
        return this.reasoningSchema;
    }

    public void setReasoningSchema(String theReasoningSchema) {
        this.reasoningSchema = theReasoningSchema;
    }

    public void setStatus(String theStatus) {
        this.status = theStatus;
    }

    public QueryInfo toQueryInfo() {
        if (this.plan != null && this.plan.length() > 0) {
            return new ExplainableQueryInfo(this.kernelId, this.id, this.queryType, this.query, this.db, this.user, this.reasoningSchema, this.startTime, this.endTime, this.preExecutionTime, this.timeout, QueryInfo.Status.valueOf((String)this.status), () -> this.plan);
        }
        return new DefaultQueryInfo(this.kernelId, this.id, this.queryType, this.query, this.db, this.user, this.reasoningSchema, this.startTime, this.endTime, this.preExecutionTime, this.timeout, QueryInfo.Status.valueOf((String)this.status));
    }
}

