/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.protocols.http.admin;

import com.complexible.stardog.protocols.http.admin.JsonOptionsObject;
import com.complexible.stardog.protocols.http.admin.PermissionsOptions;
import com.complexible.stardog.security.Permission;
import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class PermissionList
extends JsonOptionsObject {
    @SerializedName(value="permissions")
    private List<PermissionsOptions> mPermissions;

    public PermissionList() {
        this(Lists.newArrayList());
    }

    public PermissionList(List<PermissionsOptions> thePermissions) {
        this.mPermissions = thePermissions;
    }

    public List<PermissionsOptions> getPermissions() {
        return this.mPermissions;
    }

    public void setPermissions(List<PermissionsOptions> thePermissions) {
        this.mPermissions = thePermissions;
    }

    public static Collection<Permission> toPermissions(String theSubject, PermissionList theList) {
        ArrayList aList = Lists.newArrayListWithExpectedSize((int)theList.getPermissions().size());
        for (PermissionsOptions aOpts : theList.getPermissions()) {
            aList.add(PermissionsOptions.toPermission(theSubject, aOpts));
        }
        return aList;
    }

    public static PermissionList toPermissionList(Collection<Permission> thePermissions) {
        ArrayList aPerms = Lists.newArrayListWithExpectedSize((int)thePermissions.size());
        for (Permission aPerm : thePermissions) {
            aPerms.add(PermissionsOptions.toPermissionsOptions(aPerm));
        }
        return new PermissionList(aPerms);
    }
}

