/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.util;

import com.google.common.collect.Sets;
import com.stardog.stark.IRI;
import com.stardog.stark.RDFLists;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.vocabs.RDF;
import com.stardog.stark.vocabs.RDFS;
import com.stardog.stark.vocabs.XSD;
import java.net.URI;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;

public final class ResourceBuilder {
    private final Set<Statement> mGraph;
    private final Resource mRes;

    public ResourceBuilder(@Nonnull Resource theRes) {
        this(new HashSet<Statement>(), theRes);
    }

    public ResourceBuilder(@Nonnull Set<Statement> theGraph, @Nonnull Resource theRes) {
        this.mRes = theRes;
        this.mGraph = theGraph;
    }

    @Nonnull
    public ResourceBuilder addProperty(@Nonnull IRI theProperty, @Nonnull URI theURI) {
        return this.addProperty(theProperty, Values.iri(theURI.toString()));
    }

    @Nonnull
    public ResourceBuilder addProperty(@Nonnull IRI theProperty, @Nonnull List<? extends Value> theList) {
        Resource aListRes = RDFLists.create(theList, this.mGraph);
        this.mGraph.add(Values.statement(this.subject(), theProperty, aListRes));
        return this;
    }

    @Nonnull
    public ResourceBuilder addProperty(@Nonnull IRI theProperty, @Nullable Value theValue) {
        if (theValue != null) {
            this.mGraph.add(Values.statement(this.mRes, theProperty, theValue));
        }
        return this;
    }

    @Nonnull
    public ResourceBuilder addProperty(@Nonnull IRI theProperty, @Nullable Set<? extends Value> theSet) {
        if (theSet != null) {
            theSet.stream().forEach(value -> this.mGraph.add(Values.statement(this.subject(), theProperty, value)));
        }
        return this;
    }

    @Nonnull
    public Resource subject() {
        return this.mRes;
    }

    @Nonnull
    public Set<Statement> graph() {
        return this.mGraph;
    }

    @Nonnull
    public ResourceBuilder addProperty(@Nonnull IRI theProperty, @Nullable ResourceBuilder theBuilder) {
        if (theBuilder != null) {
            this.addProperty(theProperty, theBuilder.subject());
            this.mGraph.addAll(Sets.newHashSet(theBuilder.mGraph));
        }
        return this;
    }

    @Nonnull
    public ResourceBuilder addProperty(@Nonnull IRI theProperty, @Nullable String theValue) {
        if (theValue != null) {
            return this.addProperty(theProperty, Values.literal(theValue));
        }
        return this;
    }

    @Nonnull
    public ResourceBuilder addProperty(@Nonnull IRI theProperty, @Nullable Integer theValue) {
        if (theValue != null) {
            return this.addProperty(theProperty, Values.literal(theValue));
        }
        return this;
    }

    @Nonnull
    public ResourceBuilder addProperty(@Nonnull IRI theProperty, @Nullable Long theValue) {
        if (theValue != null) {
            return this.addProperty(theProperty, Values.literal(theValue));
        }
        return this;
    }

    @Nonnull
    public ResourceBuilder addProperty(@Nonnull IRI theProperty, @Nullable Short theValue) {
        if (theValue != null) {
            return this.addProperty(theProperty, Values.literal(theValue));
        }
        return this;
    }

    @Nonnull
    public ResourceBuilder addProperty(@Nonnull IRI theProperty, @Nullable Double theValue) {
        if (theValue != null) {
            return this.addProperty(theProperty, Values.literal(theValue));
        }
        return this;
    }

    @Nonnull
    public ResourceBuilder addProperty(@Nonnull IRI theProperty, @Nullable Date theValue) {
        if (theValue != null) {
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(theValue);
            try {
                return this.addProperty(theProperty, Values.literal(DatatypeFactory.newInstance().newXMLGregorianCalendar(c).toXMLFormat(), XSD.DATETIME));
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this;
    }

    @Nonnull
    public ResourceBuilder addProperty(@Nonnull IRI theProperty, @Nullable Float theValue) {
        if (theValue != null) {
            return this.addProperty(theProperty, Values.literal(theValue));
        }
        return this;
    }

    @Nonnull
    public ResourceBuilder addProperty(@Nonnull IRI theProperty, @Nullable Boolean theValue) {
        if (theValue != null) {
            return this.addProperty(theProperty, Values.literal(theValue));
        }
        return this;
    }

    @Nonnull
    public ResourceBuilder addProperty(@Nonnull IRI theProperty, @Nullable Object theObject) {
        if (theObject == null) {
            return this;
        }
        if (theObject instanceof Boolean) {
            return this.addProperty(theProperty, (Boolean)theObject);
        }
        if (theObject instanceof Long) {
            return this.addProperty(theProperty, (Long)theObject);
        }
        if (theObject instanceof Integer) {
            return this.addProperty(theProperty, (Integer)theObject);
        }
        if (theObject instanceof Short) {
            return this.addProperty(theProperty, (Short)theObject);
        }
        if (theObject instanceof Float) {
            return this.addProperty(theProperty, (Float)theObject);
        }
        if (theObject instanceof Date) {
            return this.addProperty(theProperty, (Date)theObject);
        }
        if (theObject instanceof Double) {
            return this.addProperty(theProperty, (Double)theObject);
        }
        if (theObject instanceof Value) {
            return this.addProperty(theProperty, (Value)theObject);
        }
        if (theObject instanceof List) {
            try {
                return this.addProperty(theProperty, (List)theObject);
            }
            catch (ClassCastException e) {
                e.printStackTrace();
                return this;
            }
        }
        if (theObject instanceof Set || theObject instanceof HashSet) {
            return this.addProperty(theProperty, (Set)theObject);
        }
        if (theObject instanceof ResourceBuilder) {
            return this.addProperty(theProperty, (ResourceBuilder)theObject);
        }
        if (theObject instanceof URI) {
            return this.addProperty(theProperty, (URI)theObject);
        }
        return this.addProperty(theProperty, theObject.toString());
    }

    @Nonnull
    public ResourceBuilder addLabel(@Nullable String theLabel) {
        return this.addProperty(RDFS.LABEL, theLabel);
    }

    @Nonnull
    public ResourceBuilder addType(@Nullable IRI theType) {
        return this.addProperty(RDF.TYPE, theType);
    }
}

