/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.impl;

import com.google.common.base.Preconditions;
import com.stardog.stark.Datatype;
import com.stardog.stark.IRI;
import com.stardog.stark.impl.AbstractLiteral;
import javax.annotation.Nonnull;

public final class TypedLiteral
extends AbstractLiteral {
    private final Datatype mDatatype;
    private final IRI mIRI;

    public TypedLiteral(@Nonnull String theLabel, @Nonnull Datatype theDatatype) {
        this(theLabel, theDatatype.iri(), theDatatype);
    }

    public TypedLiteral(@Nonnull String theLabel, @Nonnull IRI theIRI, @Nonnull Datatype theDatatype) {
        super(theLabel);
        Preconditions.checkNotNull((Object)theIRI);
        Preconditions.checkNotNull((Object)((Object)theDatatype));
        this.mIRI = theIRI;
        this.mDatatype = theDatatype;
    }

    @Override
    @Nonnull
    public IRI datatypeIRI() {
        return this.mIRI;
    }

    @Override
    @Nonnull
    public Datatype datatype() {
        return this.mDatatype;
    }

    @Override
    public boolean equals(Object theObject) {
        if (this == theObject) {
            return true;
        }
        if (theObject instanceof TypedLiteral) {
            TypedLiteral aLiteral = (TypedLiteral)theObject;
            if (this.datatype() == Datatype.UDF && aLiteral.datatype() == Datatype.UDF) {
                return super.equals(theObject) && this.datatypeIRI().equals(aLiteral.datatypeIRI());
            }
        }
        return super.equals(theObject);
    }
}

