/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.stardog.stark.Namespace;
import javax.annotation.Nonnull;

public final class NamespaceImpl
implements Namespace {
    private final String mPrefix;
    private final String mName;

    public NamespaceImpl(@Nonnull String thePrefix, @Nonnull String theIRI) {
        Preconditions.checkNotNull((Object)thePrefix, (Object)"Prefix cannot be null");
        Preconditions.checkNotNull((Object)theIRI, (Object)"Namespace IRI cannot be null");
        this.mPrefix = thePrefix;
        this.mName = theIRI;
    }

    @Override
    @Nonnull
    public String iri() {
        return this.mName;
    }

    @Override
    @Nonnull
    public String prefix() {
        return this.mPrefix;
    }

    public int hashCode() {
        int aPrime = 31;
        int aResult = 1;
        aResult = 31 * aResult + this.mName.hashCode();
        aResult = 31 * aResult + this.mPrefix.hashCode();
        return aResult;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Namespace) {
            Namespace other = (Namespace)obj;
            return this.mPrefix.equals(other.prefix()) && this.mName.equals(other.iri());
        }
        return false;
    }

    public String toString() {
        return this.mPrefix + " :: " + this.mName;
    }

    @Override
    public int compareTo(@Nonnull Namespace theNamespace) {
        return ComparisonChain.start().compare((Comparable)((Object)this.mPrefix), (Comparable)((Object)theNamespace.prefix())).compare((Comparable)((Object)this.mName), (Comparable)((Object)theNamespace.iri())).result();
    }
}

