/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.impl;

import com.google.common.base.Preconditions;
import com.stardog.stark.Datatype;
import com.stardog.stark.impl.LazyLabelLiteral;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.xml.datatype.Duration;

public final class DurationLiteral
extends LazyLabelLiteral {
    private final Duration mDuration;
    private final Datatype mDatatype;

    public DurationLiteral(@Nonnull Duration theDuration, @Nonnull Datatype theDatatype) {
        Preconditions.checkNotNull((Object)theDuration);
        Preconditions.checkNotNull((Object)((Object)theDatatype));
        this.mDuration = theDuration;
        this.mDatatype = theDatatype;
    }

    public Duration durationValue() {
        return this.mDuration;
    }

    @Override
    @Nonnull
    public Datatype datatype() {
        return this.mDatatype;
    }

    @Override
    protected String computeLabel() {
        return this.mDuration.toString();
    }

    @Override
    public boolean equals(Object theObject) {
        if (this == theObject) {
            return true;
        }
        if (theObject instanceof DurationLiteral) {
            DurationLiteral other = (DurationLiteral)theObject;
            return Objects.equals(other.mDuration, this.mDuration);
        }
        return super.equals(theObject);
    }
}

