/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.impl;

import com.stardog.stark.Datatype;
import com.stardog.stark.impl.LazyLabelLiteral;
import jakarta.xml.bind.DatatypeConverter;
import javax.annotation.Nonnull;

public final class ByteLiteral
extends LazyLabelLiteral {
    private final byte mByte;

    public ByteLiteral(@Nonnull String theLabel) {
        super(theLabel);
        this.mByte = DatatypeConverter.parseByte((String)theLabel);
    }

    public ByteLiteral(byte theByte) {
        this.mByte = theByte;
    }

    public byte byteValue() {
        return this.mByte;
    }

    @Override
    @Nonnull
    public Datatype datatype() {
        return Datatype.BYTE;
    }

    @Override
    protected String computeLabel() {
        return DatatypeConverter.printByte((byte)this.mByte);
    }

    @Override
    public boolean equals(Object theObject) {
        if (this == theObject) {
            return true;
        }
        if (theObject instanceof ByteLiteral) {
            ByteLiteral other = (ByteLiteral)theObject;
            return other.mByte == this.mByte;
        }
        return super.equals(theObject);
    }
}

