/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.impl;

import com.google.common.base.Preconditions;
import com.stardog.stark.Datatype;
import com.stardog.stark.Literal;
import com.stardog.stark.XMLDatatypes;
import jakarta.xml.bind.DatatypeConverter;
import javax.annotation.Nonnull;

public final class BooleanLiteral
implements Literal {
    private final boolean mValue;
    private final int mHashCode;
    public static final Literal TRUE = new BooleanLiteral(true);
    public static final Literal FALSE = new BooleanLiteral(false);

    private BooleanLiteral(boolean theValue) {
        this.mValue = theValue;
        this.mHashCode = this.label().hashCode();
    }

    public static Literal create(boolean theValue) {
        return theValue ? TRUE : FALSE;
    }

    public static Literal create(String theLabel) {
        Preconditions.checkNotNull((Object)theLabel);
        String aNormalized = XMLDatatypes.normalizeBoolean(theLabel);
        if ("true".equals(aNormalized)) {
            return TRUE;
        }
        if ("false".equals(aNormalized)) {
            return FALSE;
        }
        long aLong = DatatypeConverter.parseLong((String)theLabel);
        if (aLong == 0L) {
            return FALSE;
        }
        if (aLong == 1L) {
            return TRUE;
        }
        throw new IllegalArgumentException("Invalid label for a boolean literal: " + theLabel);
    }

    public boolean booleanValue() {
        return this.mValue;
    }

    @Override
    @Nonnull
    public String label() {
        return String.valueOf(this.mValue);
    }

    @Override
    @Nonnull
    public Datatype datatype() {
        return Datatype.BOOLEAN;
    }

    public int hashCode() {
        return this.mHashCode;
    }

    public String toString() {
        return Literal.str(this);
    }

    public boolean equals(Object theObject) {
        if (this == theObject) {
            return true;
        }
        if (theObject == null || this.getClass() != theObject.getClass()) {
            return false;
        }
        BooleanLiteral aLiteral = (BooleanLiteral)theObject;
        return this.mValue == aLiteral.mValue;
    }
}

