/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.impl;

import com.google.common.base.Preconditions;
import com.stardog.stark.Datatype;
import com.stardog.stark.impl.LazyLabelLiteral;
import jakarta.xml.bind.DatatypeConverter;
import java.math.BigInteger;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class BigIntegerLiteral
extends LazyLabelLiteral {
    private final BigInteger mInt;

    public BigIntegerLiteral(@Nonnull String theLabel) {
        super(theLabel);
        this.mInt = DatatypeConverter.parseInteger((String)theLabel);
    }

    public BigIntegerLiteral(@Nonnull BigInteger theInt) {
        Preconditions.checkNotNull((Object)theInt);
        this.mInt = theInt;
    }

    public BigInteger integerValue() {
        return this.mInt;
    }

    @Override
    @Nonnull
    public Datatype datatype() {
        return Datatype.INTEGER;
    }

    @Override
    protected String computeLabel() {
        return DatatypeConverter.printInteger((BigInteger)this.mInt);
    }

    @Override
    public boolean equals(Object theObject) {
        if (this == theObject) {
            return true;
        }
        if (theObject instanceof BigIntegerLiteral) {
            BigIntegerLiteral other = (BigIntegerLiteral)theObject;
            return Objects.equals(other.mInt, this.mInt);
        }
        return super.equals(theObject);
    }
}

