/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.impl;

import com.google.common.base.Preconditions;
import com.stardog.stark.Datatype;
import com.stardog.stark.impl.LazyLabelLiteral;
import jakarta.xml.bind.DatatypeConverter;
import java.math.BigDecimal;
import javax.annotation.Nonnull;

public final class BigDecimalLiteral
extends LazyLabelLiteral {
    private final BigDecimal mValue;

    public BigDecimalLiteral(@Nonnull String theLabel) {
        super(theLabel);
        this.mValue = DatatypeConverter.parseDecimal((String)theLabel);
    }

    public BigDecimalLiteral(@Nonnull BigDecimal theValue) {
        Preconditions.checkNotNull((Object)theValue);
        this.mValue = theValue;
    }

    public BigDecimal decimalValue() {
        return this.mValue;
    }

    @Override
    @Nonnull
    public Datatype datatype() {
        return Datatype.DECIMAL;
    }

    @Override
    protected String computeLabel() {
        return DatatypeConverter.printDecimal((BigDecimal)this.mValue);
    }

    @Override
    public boolean equals(Object theObject) {
        if (this == theObject) {
            return true;
        }
        if (theObject instanceof BigDecimalLiteral) {
            BigDecimalLiteral other = (BigDecimalLiteral)theObject;
            return other.mValue != null && other.mValue.compareTo(this.mValue) == 0;
        }
        return super.equals(theObject);
    }
}

